% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawWordcloud.R
\name{drawWordcloud}
\alias{drawWordcloud}
\title{Draw wordcloud using the collection of RAVs' MeSH terms}
\usage{
drawWordcloud(
  RAVmodel,
  ind,
  rm.noise = NULL,
  scale = c(3, 0.5),
  weighted = TRUE,
  drop = NULL,
  filterMessage = TRUE
)
}
\arguments{
\item{RAVmodel}{PCAGenomicSignatures object}

\item{ind}{An index of the RAV you want to draw wordcloud.}

\item{rm.noise}{An integer. Under the default (\code{rm.noise=NULL}), if
cluster size (= \code{s}) is smaller than 8, \code{rm.noise = floor(s*0.5)}.
For clusters with >= 8 PCs, \code{rm.noise = 4}. If \code{rm.noise = 0}, all
the MeSH terms in RAV will be used to draw wordcloud.}

\item{scale}{A \code{scale} argument for \code{\link[wordcloud]{wordcloud}}
function}

\item{weighted}{A logical. If \code{TRUE} (default), MeSH terms from each
study are weighted based on the variance explained by the principle component
of the study contributing to a given RAV.}

\item{drop}{A character vector containing MeSH terms to be excluded from word
cloud. Under the default (\code{NULL}), manually selected non-informative
MeSH terms are excluded, which can be viewed through \code{data(droplist)}.}

\item{filterMessage}{A logical. Under the default \code{TRUE}, any output
RAV belong to the filtering list will give a message. Silence this message
with \code{filterMessage=FALSE}. You can check the filter list using
\code{data("filterList")}.}
}
\value{
A word cloud with the MeSH terms associated with the given cluster.
}
\description{
Plot a word cloud using the remaining MeSH terms in the selected
RAV after user-defined filtering.
}
\examples{
data(miniRAVmodel)
drawWordcloud(miniRAVmodel, 1139)

}
