% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{extdata}
\alias{extdata}
\alias{test_file1.txt}
\alias{test_file2.txt}
\alias{test_file3.txt}
\alias{test_file4.txt}
\alias{gencode.v19.annotation_chr19.gtf}
\alias{chip_treat_chr19.bam}
\alias{treat_chr19.bam}
\alias{chip_input_chr19.bam}
\alias{input_chr19.bam}
\alias{test_wig_chr19_+.wig}
\alias{test_wig_chr19_+.bw}
\alias{test_clip_peak_chr19.bed}
\alias{test_chip_peak_chr19.bed}
\alias{test_chip_peak_chr19.narrowPeak}
\alias{test_chr19.bedGraph}
\title{Toy data for examples and testing of the `GenomicPlot` package}
\source{
The original gene annotation (gtf) file is downloaded from
     \href{https://ftp.ebi.ac.uk/pub/databases/gencode/Gencode_human/release_19/gencode.v19.annotation.gtf.gz}{https://www.gencodegenes.org/human/}. \cr
     Except for the gtf file, all other files are derived from experimental
     data produced in-house at the \href{https://thedonnellycentre.utoronto.ca/faculty/jack-greenblatt}{Greenblatt Lab, University of Toronto, Canada}.
}
\value{
Various files used as inputs to run examples and tests
}
\description{
The data files in the extdata directory contain data for next
generation sequencing read alignments, MACS2 peaks and gene annotation, which
are used to test the package and generate plots in the package vignettes.
    To meet the package file size limit, all data are restricted to
chr19:58000-507000 of the human genome version hg19. Details for each file
are as follows.
}
\details{
\itemize{
 \item "gencode.v19.annotation_chr19.gtf" is an excerpt of a gene
     annotation file by limiting to chr19:58000-507000 of the human genome.
 \item "gencode.v19.annotation_chr19.gtf.granges.rds" is a GRanges object
     produced by importing the above gtf file using RCAS::importGtf.
 \item "chip_treat_chr19.bam(.bai)" and "chip_input_chr19.bam(.bai)" are
     paired-end read alignment data from ChIPseq experiments.
 \item "treat_chr19.bam(.bai)" and "input_chr19.bam(.bai)" are single-end
     read alignment data from iCLIP experiments.
 \item "test_wig_chr19_+(-).wig", "test_wig_chr19_+(-).bw" are iCLIP
     alignment data in WIG and BIGWIG format, respectively; '+' and '-'
     represent forward and reverse strand, respectively.
 \item "test_clip_peak_chr19.bed" contains strand-specific iCLIP peak in BED
     format.
 \item "test_chip_peak_chr19.bed" and "test_chip_peak_chr19.narrowPeak"
     contain ChIPseq peaks generated with MACS2, in summit peak and narrow
     peak format, respectively. "test_chr19.bedGraph" contains the same data
     in bedGraph format.
 \item "test_file1.txt", "test_file2.txt", "test_file3.txt" and
     "test_file4.txt" are tab-delimited text files,  each contains various
     human gene names in different columns.
}
}
\author{
Shuye Pu
}
\keyword{datasets}
