% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadData.R
\name{handle_bam}
\alias{handle_bam}
\title{Handle files in bam format}
\usage{
handle_bam(inputFile, importParams = NULL, verbose = FALSE)
}
\arguments{
\item{inputFile}{a string denoting path to the input file}

\item{importParams}{a list of parameters, refer to \code{\link{handle_input}}
for details}

\item{verbose}{logical, whether to output additional information}
}
\value{
a list object with four elements, 'query' is a list GRanges objects
or RleList objects, 'size' is the library size, 'type' is the input file
type, weight' is the name of the metadata column to be used as weight for
coverage calculation
}
\description{
This is a function for read NGS reads data in bam format, store
the input data in a list of GRanges objects or RleList objects. For
paired-end reads, only take the second read in a pair, assuming which is the
sense read for strand-specific RNAseq.
}
\details{
The reads are filtered using mapq score >= 10 by default, only
 mapped reads are counted towards library size.
}
\examples{

queryFiles <- system.file("extdata", "treat_chr19.bam",
    package = "GenomicPlot"
)
names(queryFiles) <- "query"

bamimportParams <- setImportParams(
    offset = -1, fix_width = 0, fix_point = "start", norm = TRUE,
    useScore = FALSE, outRle = TRUE, useSizeFactor = FALSE, genome = "hg19"
)

out <- handle_bam(
    inputFile = queryFiles, importParams = bamimportParams, verbose = TRUE
)

}
\author{
Shuye Pu
}
