% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InteractionTrack-class.R
\docType{class}
\name{InteractionTrack-class}
\alias{InteractionTrack-class}
\alias{start,InteractionTrack-method}
\alias{end,InteractionTrack-method}
\alias{chromosome,InteractionTrack-method}
\alias{subset,InteractionTrack-method}
\title{A class to hold chromatin interaction data for a specific genomic region}
\usage{
\S4method{start}{InteractionTrack}(x)

\S4method{end}{InteractionTrack}(x)

\S4method{chromosome}{InteractionTrack}(GdObject)

\S4method{subset}{InteractionTrack}(x, from, to, chromosome, ...)
}
\arguments{
\item{x}{An InteractionTrack object}

\item{GdObject}{An InteractionTrack object}

\item{from}{Integer start coordinate of subset region}

\item{to}{Integer end coordinate of subset region}

\item{chromosome}{Chromosome of subset region}

\item{...}{additional arguments are ignored.}
}
\description{
@slot giobject GenomicInteractions object from which the object was created
 
 @slot variables list of chromosome, start, and end. Start and end can be NULL
 
 @slot chromosome chromosome defined for the object
 
 @slot stacking character
 
 @slot dp DisplayPars for the object, access with `availableDisplayPars()`
 
 @slot name Object name
 
 @slot imageMap NULL
}
\details{
InteractionTrack is a specific Gviz-derived class for enabling the
visualisation of chromatin interaction data. The InteractionTrack class
allows interactions on a specified chromosome to be visualised by examining
interactions between anchors as bezier curves. The object is instantiated and
used in a similar fashion to standard Gviz tracks and plotted using the
\code{plotTracks}.

Several additional display parameters (i.e. \code{displayPars(foo)=list(...)
}are defined for this class, including \code{plot.anchors} which can be used
to specify whether anchors are to be drawn. \code{col.anchors.line} which can
be used to alter the colour of border of these anchor elements and
\code{col.anchors.fill} can be used to alter the fill colour of these
elements.

The value of \code{plot.outside} determines whether or not interactions which
span outside of the window are to be plotted, and \code{col.outside} defines
the colour of these interactions. Similarly \code{plot.trans} determines
whether trans-interactions are plotted and \code{col.trans} specifies the
colour of trans-interactions.

By default, the height of an arc representing an interaction is proportional
to the number of reads/counts supporting that interaction. Instead of using
the counts to define this, the height can be set to be proportional to either
\code{fdr} or \code{p.value} using the \code{interaction.measure} display
parameter. By changing the \code{interaction.dimension} to width, the line
widths of each arc now represent the statistic supporting them. The heights
of the arcs can be made to be proportional to log10 of the supporting
statistic by changing \code{interaction.dimension.transform} to log.

\code{col.interactions} sets the colour of arcs representing interactions
within the region of interest. It is possible to colour the arcs by the type
of interaction they are involved in (i.e. promoter-promoter interactions etc)
by setting the \code{col.interaction.types} display parameter to be a named
vector of colours, where the name corresponds to the type of interaction.
This is applicable to anchors regions through the use of the
\code{col.anchors.line.node.class} and \code{col.anchors.fill.node.class}
parameters.
}
\section{Functions}{
\itemize{
\item \code{start,InteractionTrack-method}: Extract stored start position for object or, if that is NULL, minimum of region starts.

\item \code{end,InteractionTrack-method}: Extract stored end position for object or, if that is NULL, maximum of region ends.

\item \code{chromosome,InteractionTrack-method}: Extract stored chromosome of object

\item \code{subset,InteractionTrack-method}: Subset the object to only contain interactions within the specified genomic region
}}

