% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content-plots.R
\name{calcDinuclFreqRef}
\alias{calcDinuclFreqRef}
\title{Calculate dinucleotide content over genomic ranges}
\usage{
calcDinuclFreqRef(query, refAssembly, rawCounts = FALSE)
}
\arguments{
\item{query}{A GRanges object with query sets}

\item{refAssembly}{A character vector specifying the reference genome
assembly (*e.g.* 'hg19'). This will be used to grab chromosome sizes with
\code{getTSSs}.}

\item{rawCounts}{a logical indicating whether the raw numbers should be 
displayed, rather than percentages (optional).}
}
\value{
A numeric vector or list of vectors with the GC percentage of 
    the query regions.
}
\description{
Given a reference genome (BSgenome object) and ranges on the
reference, this function returns a data.table with 
counts of dinucleotides within the GRanges object.
}
\examples{
\dontrun{
query = system.file("extdata", "vistaEnhancers.bed.gz", package="GenomicDistributions")
GRquery = rtracklayer::import(query)
refAssembly = 'hg19'
DNF = calcDinuclFreqRef(GRquery, refAssembly)
} 
}
