% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caching.R
\name{gdc_cache}
\alias{gdc_cache}
\alias{gdc_set_cache}
\title{Work with gdc cache directory}
\usage{
gdc_cache()

gdc_set_cache(
  directory = rappdirs::app_dir(appname = "GenomicDataCommons")$cache(),
  verbose = TRUE,
  create_without_asking = !interactive()
)
}
\arguments{
\item{directory}{character(1) directory path, will be created
recursively if not present.}

\item{verbose}{logical(1) whether or not to message the location of
the cache directory after creation.}

\item{create_without_asking}{logical(1) specifying whether to allow
the function to create the cache directory without asking the
user first. In an interactive session, if the cache directory
does not exist, the user will be prompted before creation.}
}
\value{
character(1) directory path that serves as
the base directory for GenomicDataCommons downloads.

the created directory (invisibly)
}
\description{
The GenomicDataCommons package will cache downloaded
files to minimize network and allow for
offline work. These functions are used to create a cache directory
if one does not exist, set a global option, and query that
option. The cache directory will default to the user "cache"
directory according to specifications in
\code{\link[rappdirs]{app_dir}}. However, the user may want to set
this to another direcotory with more or higher performance
storage.
}
\details{
The cache structure is currently just a directory with each file
    being represented by a path constructed as:
    CACHEDIR/UUID/FILENAME. The cached files can be manipulated
    using standard file system commands (removing, finding,
    etc.). In this sense, the cache sytem is minimalist in design.
}
\section{Functions}{
\itemize{
\item \code{gdc_set_cache()}: (Re)set the GenomicDataCommons cache
directory

}}
\examples{
gdc_cache()
\dontrun{
gdc_set_cache(getwd())
}

}
