% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filtering}
\alias{filtering}
\alias{filter}
\alias{filter.GDCQuery}
\alias{get_filter}
\alias{get_filter.GDCQuery}
\title{Manipulating GDCQuery filters}
\usage{
filter(x, expr)

\method{filter}{GDCQuery}(x, expr)

get_filter(x)

\method{get_filter}{GDCQuery}(x)
}
\arguments{
\item{x}{the object on which to set the filter list
member}

\item{expr}{a filter expression in the form of
the right hand side of a formula, where bare names
(without quotes) are allowed if they are available
fields associated with the GDCQuery object, \code{x}}
}
\value{
A \code{\link{GDCQuery}} object with the filter
field replaced by specified filter expression
}
\description{
Manipulating GDCQuery filters

The \code{filter} is simply a safe accessor for
the filter element in \code{\link{GDCQuery}} objects.

The \code{get_filter} is simply a safe accessor for
the filter element in \code{\link{GDCQuery}} objects.
}
\examples{
# make a GDCQuery object to start
#
# Projects
#
pQuery = projects()

# check for the default fields
# so that we can use one of them to build a filter
default_fields(pQuery)
pQuery = filter(pQuery,~ project_id == 'TCGA-LUAC')
get_filter(pQuery)

#
# Files
#
fQuery = files()
default_fields(fQuery)

fQuery = filter(fQuery,~ data_format == 'VCF')
# OR
# with recent GenomicDataCommons versions:
#   no "~" needed
fQuery = filter(fQuery, data_format == 'VCF')

get_filter(fQuery)

fQuery = filter(fQuery,~ data_format == 'VCF'
                & experimental_strategy == 'WXS'
                & type == 'simple_somatic_mutation')

files() |> filter(~ data_format == 'VCF'
                   & experimental_strategy=='WXS'
                   & type == 'simple_somatic_mutation') |> count()
                   
                   
files() |> filter( data_format == 'VCF'
                   & experimental_strategy=='WXS'
                   & type == 'simple_somatic_mutation') |> count()

# Filters may be chained for the 
# equivalent query
# 
# When chained, filters are combined with logical AND

files() |>
  filter(~ data_format == 'VCF') |>
  filter(~ experimental_strategy == 'WXS') |>
  filter(~ type == 'simple_somatic_mutation') |>
  count()

# OR

files() |>
  filter( data_format == 'VCF') |>
  filter( experimental_strategy == 'WXS') |>
  filter( type == 'simple_somatic_mutation') |>
  count()

# Use str() to get a cleaner picture
str(get_filter(fQuery))
}
