% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2dig.R
\name{str2dig}
\alias{str2dig}
\alias{str2dig,character-method}
\alias{str2dig,list-method}
\title{String to Digits}
\usage{
str2dig(x, split = "", ...)

\S4method{str2dig}{character}(x, split = "", ...)

\S4method{str2dig}{list}(x, split = "", num.cores = 1L, tasks = 0L, verbose = FALSE, ...)
}
\arguments{
\item{x}{A character string or a list/ of character strings of
numeric/digit symbols.}

\item{split}{The same as in \code{\link[base]{strsplit}}}

\item{...}{Further parameters for \code{\link[base]{strsplit}}.}

\item{num.cores, tasks}{Parameters for parallel computation using package
\code{\link[BiocParallel]{BiocParallel-package}}: the number of cores to
use, i.e. at most how many child processes will be run simultaneously (see
\code{\link[BiocParallel]{bplapply}} and the number of tasks per job (only
for Linux OS).}

\item{verbose}{If TRUE, prints the function log to stdout.}
}
\value{
A integer vector or a list of integer vectors.
}
\description{
A simple function to transform a string of digits into a
numeric vector.
}
\examples{
## A integer vector
str2dig("12231456247")

## A list of integer vectors
str2dig(list(num1 = "12231456247", num2 = "521436897"))
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
