% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_map.R
\name{enrichment_map}
\alias{enrichment_map}
\title{Creates an enrichment map for the results of functional enrichment}
\usage{
enrichment_map(
  res_enrich,
  res_de,
  annotation_obj,
  gtl = NULL,
  n_gs = 50,
  gs_ids = NULL,
  overlap_threshold = 0.1,
  scale_edges_width = 200,
  scale_nodes_size = 5,
  color_by = "gs_pvalue"
)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).}

\item{res_de}{A \code{DESeqResults} object.}

\item{annotation_obj}{A \code{data.frame} object with the feature annotation
information, with at least two columns, \code{gene_id} and \code{gene_name}.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}

\item{n_gs}{Integer value, corresponding to the maximal number of gene sets to
be displayed}

\item{gs_ids}{Character vector, containing a subset of \code{gs_id} as they are
available in \code{res_enrich}. Lists the gene sets to be displayed.}

\item{overlap_threshold}{Numeric value, between 0 and 1. Defines the threshold
to be used for removing edges in the enrichment map - edges below this value
will be excluded from the final graph. Defaults to 0.1.}

\item{scale_edges_width}{A numeric value, to define the scaling factor for the
edges between nodes. Defaults to 200 (works well chained to \code{visNetwork}
functions).}

\item{scale_nodes_size}{A numeric value, to define the scaling factor for the
node sizes. Defaults to 5 - works well chained to \code{visNetwork} functions.}

\item{color_by}{Character, specifying the column of \code{res_enrich} to be used
for coloring the plotted gene sets. Defaults to \code{gs_pvalue}.}
}
\value{
An \code{igraph} object to be further manipulated or processed/plotted
}
\description{
Generates a graph for the enrichment map, combining information from \code{res_enrich}
and \code{res_de}. This object can be further plotted, e.g. statically via
\code{\link[igraph:plot.igraph]{igraph::plot.igraph()}}, or dynamically via
\link[visNetwork:visNetwork-igraph]{visNetwork::visIgraph()}
}
\examples{
library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

em <- enrichment_map(res_enrich,
  res_de,
  anno_df,
  n_gs = 20
)

em

# could be viewed interactively with
# library("visNetwork")
# library("magrittr")
# em \%>\%
#   visIgraph() \%>\%
#   visOptions(highlightNearest = list(enabled = TRUE,
#                                      degree = 1,
#                                      hover = TRUE),
#             nodesIdSelection = TRUE)
}
\seealso{
\code{\link[=GeneTonic]{GeneTonic()}} embeds an interactive visualization for the enrichment map
}
