% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leafCutter.R
\name{exonsToTranscripts}
\alias{exonsToTranscripts}
\title{Convert an exon-level gtf annotation to a transcript-level gtf annotation}
\usage{
exonsToTranscripts(exons)
}
\arguments{
\item{exons}{GRanges object with exons}
}
\value{
GRanges object with transcripts
}
\description{
Convert an exon-level gtf annotation to a transcript-level gtf annotation
}
\examples{
gtf <- rtracklayer::import(system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools"))
exons <- gtf[gtf$type=="exon" & gtf$transcript_id=="ENSMUST00000126412.1"]
exons
transcripts <- exonsToTranscripts(exons)
transcripts
}
\seealso{
Other gtf manipulation: \code{\link{UTR2UTR53}},
  \code{\link{addBroadTypes}},
  \code{\link{filterGtfOverlap}},
  \code{\link{removeDuplicateTranscripts}},
  \code{\link{removeSameExon}},
  \code{\link{reorderExonNumbers}}
}
\author{
Beth Signal
}
