% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prepareGenesetData}
\alias{prepareGenesetData}
\title{Split string of genes}
\usage{
prepareGenesetData(genesets, gene_name = NULL)
}
\arguments{
\item{genesets}{a \code{data.frame}, A \code{data.frame} with at least two columns.
One should be called \code{Geneset}, containing the
names/identifiers of the genesets in the data. The second
column should be called \code{Genes} and contains one string of
the genes contained in each geneset.}

\item{gene_name}{a character, Alternative name for the column containing the
genes in \code{genesets}. If not given, the column is expected to
be called \code{Genes}.}
}
\value{
A \code{list} containing for each geneset in the \code{Geneset} column a
\code{list} of the included genes.
}
\description{
Split a long string of space separated genes into a \code{list} of individual
genes.
}
\examples{
## Mock example showing how the data should look like
df <- data.frame(
  Geneset = c(
    "Cell Cycle",
    "Biological Process",
    "Mitosis"
  ),
  Genes = c(
    c("PDHB,VARS2,IARS2"),
    c("LARS,LARS2"),
    c("IARS,SUV3")
  )
)
genes <- prepareGenesetData(df)

## Example using the data available in the package
data(macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
genes <- prepareGenesetData(macrophage_topGO_example_small)
}
