% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{louvainClustering}
\alias{louvainClustering}
\title{Cluster genesets using Louvain clustering.}
\usage{
louvainClustering(scores, threshold)
}
\arguments{
\item{scores}{A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} of (distance) scores}

\item{threshold}{numerical, A threshold used to determine which genesets are
considered similar. Genesets are considered similar if
(distance) score <= threshold.
similar.}
}
\value{
A \code{list} of clusters
}
\description{
This function is a wrapper function for the Louvain clustering.
The actual computation of the clustering is done in the \code{GeDi::clustering()}
function. This function is mainly a wrapper function for stand-alone use of
GeDi functionalities to enhance user experience and allow for a clearer
distinction of the individual clustering algorithms.
}
\examples{
## Mock example showing how the data should look like
m <- Matrix::Matrix(stats::runif(100, min = 0, max = 1), 10, 10)
rownames(m) <- colnames(m) <- c("a", "b", "c", "d", "e",
                                "f", "g", "h", "i", "j")
louvainCluster <- louvainClustering(m, 0.3)

## Example using the data available in the package
data(scores_macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())

louvainCluster <- louvainClustering(scores_macrophage_topGO_example_small,
                        threshold = 0.5)
}
