% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_Graph.R
\name{buildGraph}
\alias{buildGraph}
\title{Construct a graph}
\usage{
buildGraph(adjMatrix, geneset_df = NULL, gs_names = NULL, weighted = FALSE)
}
\arguments{
\item{adjMatrix}{A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} indicating for which pair of nodes an
edge should be added; 1 indicating an edge, 0 indicating no
edge.}

\item{geneset_df}{\code{data.frame}, a \code{data.frame} of genesets with at least two
columns, one called \code{Genesets} containing geneset
identifiers and one called \code{Genes} containing a list of
genes belonging to the individual genesets.}

\item{gs_names}{vector, a vector of geneset descriptions/names, e.g. the
\code{Term} / \code{Description} column of \code{geneset_df}.}

\item{weighted}{logical value, whether or not the resulting graph should have
weighted edges. If TRUE, the \code{adjMatrix} values will be used
as weights. Default to FALSE.}
}
\value{
An \code{igraph} object to be further manipulated or processed/plotted
(e.g. via \code{\link[igraph:plot.igraph]{igraph::plot.igraph()}} or
\link[visNetwork:visNetwork-igraph]{visNetwork::visIgraph()})
}
\description{
Construct a graph from a given adjacency matrix
}
\examples{
adj <- Matrix::Matrix(0, 100, 100)
adj[c(80:100), c(80:100)] <- 1
geneset_names <- as.character(stats::runif(100, min = 0, max = 1))
rownames(adj) <- colnames(adj) <- geneset_names
graph <- buildGraph(adj)
}
