% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_Graph.R
\name{buildClusterGraph}
\alias{buildClusterGraph}
\title{Build a cluster graph}
\usage{
buildClusterGraph(
  cluster,
  geneset_df,
  gs_ids,
  color_by = NULL,
  gs_names = NULL
)
}
\arguments{
\item{cluster}{list, a \code{list} of clusters, where each cluster member is
indicated by a numeric value.}

\item{geneset_df}{\code{data.frame}, a \code{data.frame} of genesets with at least two
columns, one called \code{Genesets} containing geneset
identifiers and one called \code{Genes} containing a list of
genes belonging to the individual genesets.}

\item{gs_ids}{vector, a vector of geneset identifiers, e.g. the \code{Genesets}
column of \code{geneset_df}.}

\item{color_by}{character, a column name of \code{geneset_df} which is used
to color the nodes of the resulting graph. The column should
ideally contain a numeric measurement. Defaults to NULL and
nodes will remain uncolored.}

\item{gs_names}{vector, a vector of geneset descriptions/names, e.g. the
\code{Term} / \code{Description} column of \code{geneset_df}.}
}
\value{
An \code{igraph} object to be further manipulated or processed/plotted
(e.g. via \code{\link[igraph:plot.igraph]{igraph::plot.igraph()}} or
\link[visNetwork:visNetwork-igraph]{visNetwork::visIgraph()})
}
\description{
Build a \code{igraph} from cluster information, connecting nodes which belong to
the same cluster.
}
\examples{
cluster <- list(c(1:5), c(6:9, 1))
genes <- list(
  c("PDHB", "VARS2"), c("IARS2", "PDHA1"),
  c("AAAS", "ABCE1"), c("ABI1", "AAR2"), c("AATF", "AMFR"),
  c("BMS1", "DAP3"), c("AURKAIP1", "CHCHD1"), c("IARS2"),
  c("AHI1", "ALMS1")
)
gs_names <- c("a", "b", "c", "d", "e", "f", "g", "h", "i")
gs_ids <- c(1:9)
geneset_df <- data.frame(
  Genesets = gs_names,
  value = rep(1, 9)
)
geneset_df$Genes <- genes
graph <- buildClusterGraph(
  cluster = cluster,
  geneset_df = geneset_df,
  gs_ids = gs_ids,
  color_by = "value",
  gs_names = gs_names
)
}
