% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_gost}
\alias{is_gost}
\title{Determine if an object is a gost object}
\usage{
is_gost(gost_result)
}
\arguments{
\item{gost_result}{list, gprofiler2::gost result}
}
\value{
list, a boolean as first element and in second element NULL or the
reason why boolean is set to FALSE
}
\description{
Check content of a given object to determine if it's a gost object
}
\examples{
single_module <- c("BIRC3", "PMAIP1", "CASP8", "JUN", "BCL2L11", "MCL1",
                   "IL1B", "SPTAN1", "DIABLO", "BAX", "BIK", "IL1A", "BID",
                   "CDKN1A", "GADD45A")
single_module_enriched <- bio_enrich(single_module)
is_gost(single_module_enriched)

}
