% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biological_integration.R
\name{associate_phenotype}
\alias{associate_phenotype}
\title{Modules phenotpic association}
\usage{
associate_phenotype(
  eigengenes,
  phenotypes,
  cor_func = c("pearson", "spearman", "kendall", "other"),
  your_func = NULL,
  id_col = NULL,
  ...
)
}
\arguments{
\item{eigengenes}{matrix or data.frame, eigengenes of the modules.
Provided by the output of modules_detection.}

\item{phenotypes}{matrix or data.frame, phenotypes for each sample to
associate.}

\item{cor_func}{string, name of the correlation function to be used. Must be
one of "pearson", "spearman", "kendall", "other". If "other", your_func must
be provided}

\item{your_func}{function returning a correlation matrix. Final values must 
be in [-1;1] range}

\item{id_col}{string or vector of string, optional name of the columns
containing the common id between eigengenes and phenotypes.}

\item{...}{any arguments compatible with \code{\link[stats]{cor}}.}
}
\value{
A list of two data.frames : associations modules/phenotype and
p.values associated to this associations
}
\description{
Compute the correlation between all modules and the phenotypic variables
}
\examples{
eigengene_mat <- data.frame(mod1 = rnorm(20, 0.1, 0.2),
mod2 = rnorm(20, 0.2, 0.2))
phenotype_mat <- data.frame(phenA = sample(c("X", "Y", "Z"), 20,
                            replace = TRUE),
                            phenB = sample(c("U", "V"), 20, replace = TRUE),
                            stringsAsFactors = FALSE)
association <- associate_phenotype(eigengene_mat, phenotype_mat)

}
