% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-functions.R
\name{to_dataframe}
\alias{to_dataframe}
\title{Convert galgo.Obj to data.frame}
\usage{
to_dataframe(output)
}
\arguments{
\item{output}{An object of class \code{galgo.Obj}}
}
\value{
The current function restructurates a \code{galgo.Obj} to a more 
easy to understand an use \code{data.frame}. The output \code{data.frame} 
has \eqn{ m x n} dimensions, were the rownames (\eqn{m}) are the solutions 
obtained by the \code{\link[GSgalgoR:galgo]{galgo}} algorithm. 
The columns has the following structure:
\enumerate{
\item \strong{Genes}: The features included in each solution in form 
of a \code{list}
\item \strong{k}: The number of partitions found in that solution
\item \strong{SC.Fit}: The average silhouette coefficient of the 
partitions found
\item \strong{Surv.Fit}: The survival fitness value
\item \strong{Rank}: The solution rank
\item \strong{CrowD}: The solution crowding distance related to the 
rest of the solutions
}
}
\description{
The current function transforms a \code{galgo.Obj} to a \code{data.frame}
}
\examples{
# load example dataset
library(breastCancerTRANSBIG)
data(transbig)
Train <- transbig
rm(transbig)

expression <- Biobase::exprs(Train)
clinical <- Biobase::pData(Train)
OS <- survival::Surv(time = clinical$t.rfs, event = clinical$e.rfs)

# We will use a reduced dataset for the example
expression <- expression[sample(1:nrow(expression), 100), ]

# Now we scale the expression matrix
expression <- t(scale(t(expression)))

# Run galgo
output <- GSgalgoR::galgo(generations = 5, population = 15, 
prob_matrix = expression, OS = OS)
outputDF <- to_dataframe(output)
outputList <- to_list(output)
}
\author{
Martin E Guerrero-Gimenez, \email{mguerrero@mendoza-conicet.gob.ar}
}
