% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results-functions.R
\name{create_centroids}
\alias{create_centroids}
\title{Create Centroids}
\usage{
create_centroids (output, solution_names, trainset,
distancetype = "pearson")
}
\arguments{
\item{output}{@param output An object of class \code{galgo.Obj}}

\item{solution_names}{A \code{character} vector with the names of the
solutions for which the centroids are to be calculated}

\item{trainset}{a \code{matrix} or \code{data.frame}. Must be an expression
matrix with features in rows and samples in columns}

\item{distancetype}{a \code{character} that can be either \code{'pearson'},
\code{'uncentered'}, \code{'spearman'} or \code{'euclidean'}}
}
\value{
Returns a list with the centroid matrix for each of the solutions
in \code{solution_names}, where each column represents the prototypic
centroid of a subtype and each row the constituents features of the
solution signature
}
\description{
This functions create the signature centroids estimated from the
GalgoR output and the expression matrix of the training sets.
}
\examples{
# load example dataset
library(breastCancerTRANSBIG)
data(transbig)
Train <- transbig
rm(transbig)

expression <- Biobase::exprs(Train)
clinical <- Biobase::pData(Train)
OS <- survival::Surv(time = clinical$t.rfs, event = clinical$e.rfs)

# We will use a reduced dataset for the example
expression <- expression[sample(1:nrow(expression), 100), ]

# Now we scale the expression matrix
expression <- t(scale(t(expression)))

# Run galgo
output <- GSgalgoR::galgo(generations = 5, population = 15,
prob_matrix = expression, OS = OS)
outputDF <- to_dataframe(output)
outputList <- to_list(output)

RESULTS <- non_dominated_summary(
    output = output, OS = OS,
    prob_matrix = expression,
    distancetype = "pearson"
)
CentroidsList <- create_centroids(output, RESULTS$solution,
trainset = expression)
}
