% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_enrichcores.R
\name{gm_enrichcores}
\alias{gm_enrichcores}
\title{gm_enrichcores: GSEAmining core enrichment genes}
\usage{
gm_enrichcores(
  df,
  hc,
  clust = TRUE,
  col_pos = "red",
  col_neg = "blue",
  top = 3
)
}
\arguments{
\item{df}{Data frame that contains at least three columns: an ID column for
the gene set names, a NES column with the normalized enrichment score and a
core_enrichment column containing the genes in the leading edge of each
gene set separated by '/'.}

\item{hc}{The output of gm_clust, which is an hclust class object.}

\item{clust}{A logical value indicating if wordclouds should be separated by
clusters or not. Default value is TRUE.}

\item{col_pos}{Color to represent positively enriched gene sets. Default
is red.}

\item{col_neg}{Color to represent negatively enriched gene sets. Default
is blue.}

\item{top}{An integer to choose the top most enriched genes to plot per
cluster. The default parameter are the top 3.}
}
\value{
Returns a ggplot object.
}
\description{
Takes the output of gm_clust, which is an hclust class object,
and plots the top n genes in core enrichment (leading edge analysis).
Two options are available, either separate barplots by clusters or all
together in one plot.
}
\examples{
data(genesets_sel)
gs.cl <- gm_clust(genesets_sel)
gm_enrichcores(genesets_sel, gs.cl)

}
