% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{addConnections_peak_gene}
\alias{addConnections_peak_gene}
\title{Add peak-gene connections to a \code{\linkS4class{GRN}} object}
\usage{
addConnections_peak_gene(
  GRN,
  overlapTypeGene = "TSS",
  corMethod = "pearson",
  promoterRange = 250000,
  TADs = NULL,
  TADs_mergeOverlapping = FALSE,
  knownLinks = NULL,
  knownLinks_separator = c(":", "-"),
  knownLinks_useExclusively = FALSE,
  shuffleRNACounts = TRUE,
  nCores = 4,
  plotDiagnosticPlots = TRUE,
  plotGeneTypes = list(c("all"), c("protein_coding")),
  outputFolder = NULL,
  forceRerun = FALSE
)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{overlapTypeGene}{Character. \code{"TSS"} or \code{"full"}. Default \code{"TSS"}. If set to \code{"TSS"}, only the TSS of the gene is used as reference for finding genes in the neighborhood of a peak. If set to \code{"full"}, the whole annotated gene (including all exons and introns) is used instead.}

\item{corMethod}{Character. One of \code{pearson}, \code{spearman} or \code{bicor}. Default \code{pearson}. Method for calculating the correlation coefficient. 
For \code{pearson} and \code{spearman} , see \link{cor} for details. \code{bicor} denotes the *biweight midcorrelation*, a correlation measure based on medians as
calculated by \code{WGCNA::bicorAndPvalue}. Both \code{spearman} and \code{bicor} are considered more robust measures that are less prone to be affected by outliers.}

\item{promoterRange}{Integer >=0. Default 250000. The size of the neighborhood in bp to correlate peaks and genes in vicinity. Only peak-gene pairs will be correlated if they are within the specified range. Increasing this value leads to higher running times and more peak-gene pairs to be associated, while decreasing results in the opposite.}

\item{TADs}{Data frame with TAD domains. Default \code{NULL}. If provided, the neighborhood of a peak is defined by the TAD domain the peak is in rather than a fixed-sized neighborhood. The expected format is a BED-like data frame with at least 3 columns in this particular order: chromosome, start, end, the 4th column is optional and will be taken as ID column. All additional columns as well as column names are ignored. For the first 3 columns, the type is checked as part of a data integrity check.}

\item{TADs_mergeOverlapping}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Should overlapping TADs be merged? Only relevant if TADs are provided.}

\item{knownLinks}{\code{NULL} or a data frame with exactly two columns. Both columns must be of type character and they must both contain 
genomic coordinates in the usual format: \code{chr:start-end}, while the 2 separators between the three elements can be chosen by the user.
The first column denotes the **bait**, the promoter coordinates that are overlapped with the genes (usually their TSS, unless specified 
otherwise via the parameter \code{overlapTypeGene}, while the second column denotes the **other end (OE)** coordinates, which is overlapped with the
peaks/enhancers from the GRN object. 
**NOTE: The provided column names are ignored and column 1 is interpreted as bait column and column 2 as OE column unless column names are exactly `bait` and `OE`.**.  
For more details, see the Workflow vignette.)}

\item{knownLinks_separator}{Character vector of length 1 or 2. Default \code{c(":", "-")}. Separator(s) for the character columns that specify the genomic locations.
The first entry splits the chromosome from the position, while the second entry splits the start and end coordinates. If only one separator is given, the same will be used for both.}

\item{knownLinks_useExclusively}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. If kept at \code{FALSE} (the default),
specified \code{knownLinks} will be used in addition to the regular peak-gene links that are identified via the default method. 
If set to \code{TRUE}, only the \code{knownLinks} will be used.}

\item{shuffleRNACounts}{\code{TRUE} or \code{FALSE}. Default \code{TRUE}. Should the RNA sample labels be shuffled in addition to 
testing random peak-gene pairs for the background? When set to \code{FALSE}, only peak-gene pairs are shuffled, but
for each pair, the counts from peak and RNA that are correlated are matched (i.e., sample 1 counts from peak data are compared to sample 1 counts from RNA).
If set to \code{TRUE}, however, the RNA sample labels are in addition shuffled so that sample 1 counts from peak data are compared to sample 4 data from RNA, for example.
Shuffling truly randomizes the resulting background eGRN. Note that this parameter and its influence is still being investigated. Until version 1.0.7, this parameter (although not existent explicitly)
was implicitly set to \code{TRUE}.}

\item{nCores}{Integer >0. Default 1. Number of cores to use. 
A value >1 requires the \code{BiocParallel} package (as it is listed under \code{Suggests}, it may not be installed yet).}

\item{plotDiagnosticPlots}{\code{TRUE} or \code{FALSE}. Default \code{TRUE}. Run and plot various diagnostic plots? If set to \code{TRUE}, PDF files will be produced and saved in the output directory (in a subfolder called \code{plots}).}

\item{plotGeneTypes}{List of character vectors. Default \code{list(c("all"), c("protein_coding"))}. Each list element may consist of one or multiple gene types that are plotted collectively in one PDF. The special keyword \code{"all"} denotes all gene types that are found (be aware: this typically contains 20+ gene types, see \url{https://www.gencodegenes.org/pages/biotypes.html} for details).}

\item{outputFolder}{Character or \code{NULL}. Default \code{NULL}. If set to \code{NULL}, the default output folder as specified when initiating the 
object in \code{\link{initializeGRN}} will be used. Otherwise, all output from this function will be put into the specified folder. 
If a folder is provided, while we recommend specifying an absolute path, a relative one also works.}

\item{forceRerun}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Force execution, even if the GRN object already contains the result. Overwrites the old results.}
}
\value{
An updated \code{\linkS4class{GRN}} object, with additional information added from this function.
}
\description{
After the execution of this function, QC plots can be plotted with the function \code{\link{plotDiagnosticPlots_peakGene}} unless this has already been done by default due to \code{plotDiagnosticPlots = TRUE}
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
GRN = addConnections_peak_gene(GRN, promoterRange=10000, plotDiagnosticPlots = FALSE)
}
\seealso{
\code{\link{plotDiagnosticPlots_peakGene}}
}
