% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R
\docType{class}
\name{GRN-class}
\alias{GRN-class}
\title{Create, represent, investigate, quantify and visualize enhancer-mediated gene regulatory networks (\strong{eGRNs})}
\description{
The class \code{\linkS4class{GRN}} stores data and information related to our \code{eGRN} approach to construct enhancer-mediated gene regulatory networks out of open chromatin and RNA-Seq data. See the description below for more details, and \strong{visit our project website at https://grp-zaugg.embl-community.io/GRaNIE and have a look at the various Vignettes}.
}
\section{Slots}{

\describe{
\item{\code{data}}{Currently stores 4 different types of data:\cr 
\itemize{
\item \code{peaks}:
 \itemize{
 \item \code{counts}:
 \item \code{counts_metadata}:
 }
\item \code{RNA}: 
 \itemize{
 \item \code{counts}:
 \item \code{counts_metadata}:
 \item \code{counts_permuted_index}:
 }
\item \code{TFs}: 
 \itemize{
 \item \code{TF_activity}:
 \item \code{TF_peak_overlap}:
 \item \code{classification}:
 }
}}

\item{\code{config}}{Contains general configuration data and parameters such as parameters, files, directories, flags, and recorded function parameters.}

\item{\code{connections}}{Stores various types of connections}

\item{\code{annotation}}{Stores annotation data for peaks and genes}

\item{\code{stats}}{Stores statistical and summary information for a \code{GRN} network. Currently, connection details are stored here.}

\item{\code{graph}}{Stores the eGRN graph related information and data structures}
}}

\section{Constructors}{

Currently, a \code{\linkS4class{GRN}} object is created by executing the function \code{\link{initializeGRN}}.
}

\section{Accessors}{

In the following code snippets, \code{GRN} is a \code{\linkS4class{GRN}} object.

# Get general annotation of a GRN object from the GRaNIE package

\code{nPeaks(GRN))}, \code{nTFs(GRN))} and \code{nGenes(GRN))}: Retrieve the number of peaks, TFs and genes, respectively, that have been added to the object (both before and after filtering)
}

\keyword{GRN}
\keyword{GRN-class,}
