% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDSArray-classes.R
\docType{class}
\name{extract_array}
\alias{extract_array}
\alias{extract_array,GDSArraySeed-method}
\alias{GDSArray-class}
\alias{matrixClass,GDSArray-method}
\alias{GDSMatrix}
\alias{GDSMatrix-class}
\alias{coerce}
\alias{coerce,GDSArray,GDSMatrix-method}
\alias{coerce,GDSMatrix,GDSArray-method}
\alias{coerce,ANY,GDSMatrix-method}
\alias{GDSArray}
\alias{GDSArray-method}
\alias{gdsExampleFileName}
\alias{GDSArray-data}
\title{GDSArray constructor and coercion methods.}
\usage{
\S4method{extract_array}{GDSArraySeed}(x, index)

GDSArray(gdsfile, varname)

gdsExampleFileName(type = c("seqgds", "snpgds"))
}
\arguments{
\item{x}{the GDSArraySeed object}

\item{index}{An unnamed list of subscripts as positive integer
vectors, one vector per dimension in \code{x}. Empty and
missing subscripts (represented by \code{integer(0)} and
\code{NULL} list elements, respectively) are allowed. The
subscripts can contain duplicated indices. They cannot contain
NAs or non-positive values.}

\item{gdsfile}{Can be a GDSArraySeed, a character string of gds
file name, or an "gds.class" R object.}

\item{varname}{A character string specifying the gds array node to
be read into GDSArray.}

\item{type}{the type of gds file, available are "seqgds" for
\code{SeqVarGDSClass} and "snpgds" for \code{SNPGDSFileClass}.}
}
\value{
\code{GDSArray} class object.
}
\description{
\code{extract_array}: the function to extract data from
    a \code{GDS} file, by taking \code{GDSArraySeed} as input. This
    function is required by the \code{DelayedArray} for the seed
    contract.

\code{GDSArray}: The function to convert a gds file
    into the GDSArray data structure.

\code{GDSArray} example data
}
\examples{
fn <- gdsExampleFileName("snpgds") 
allnodes <- gdsnodes(fn)  ## print all available gds nodes in fn.
allnodes
GDSArray(fn, "genotype")
GDSArray(fn, "sample.annot/pop.group")

fn1 <- gdsExampleFileName("seqgds")
allnodes1 <- gdsnodes(fn1)  ## print all available gds nodes in fn1. 
allnodes1
## GDSArray(fn1, "genotype/data")
GDSArray(fn1, "variant.id")
GDSArray(fn1, "sample.annotation/family")
GDSArray(fn1, "annotation/format/DP/data")
GDSArray(fn1, "annotation/info/DP")
gdsExampleFileName("snpgds")
gdsExampleFileName("seqgds")
}
