% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdcDEGVisulization.R
\name{gdcHeatmap}
\alias{gdcHeatmap}
\title{Heatmap of differentially expressed genes/miRNAs}
\usage{
gdcHeatmap(deg.id, metadata, rna.expr)
}
\arguments{
\item{deg.id}{a vector of Ensembl gene ids or miRBase v21 mature miRNA ids}

\item{metadata}{metadata parsed from \code{\link{gdcParseMetadata}}}

\item{rna.expr}{\code{\link[limma]{voom}} transformed expression data}
}
\value{
A heatmap with rows are DE genes/miRNAs and columns are samples.
    \emph{Solid Tissue Normal} samples are labeled with blue and 
    \emph{Primary Tumor} samples are labeled with red
}
\description{
A heatmap showing unsupervised hierarchical clustering of 
    DE genes/miRNAs by \code{\link[gplots]{heatmap.2}} in the 
    \pkg{gplots} package
}
\examples{
genes <- c('ENSG00000000938','ENSG00000000971','ENSG00000001036',
        'ENSG00000001084','ENSG00000001167','ENSG00000001460')

samples <- c('TCGA-2F-A9KO-01', 'TCGA-2F-A9KP-01',
            'TCGA-2F-A9KQ-01', 'TCGA-2F-A9KR-01',
             'TCGA-2F-A9KT-01', 'TCGA-2F-A9KW-01')
             
metaMatrix <- data.frame(sample_type=rep('PrimaryTumor',6),
                        sample=samples,
                        days_to_death=seq(100,600,100),
                        days_to_last_follow_up=rep(NA,6))
rnaExpr <- matrix(c(2.7,7.0,4.9,6.9,4.6,2.5,
                    0.5,2.5,5.7,6.5,4.9,3.8,
                    2.1,2.9,5.9,5.7,4.5,3.5,
                    2.7,5.9,4.5,5.8,5.2,3.0,
                    2.5,2.2,5.3,4.4,4.4,2.9,
                    2.4,3.8,6.2,3.8,3.8,4.2),6,6)
rownames(rnaExpr) <- genes
colnames(rnaExpr) <- samples
gdcHeatmap(deg.id=genes, metadata=metaMatrix, rna.expr=rnaExpr)
}
\author{
Ruidong Li and Han Qu
}
