% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{thinMarker}
\alias{thinMarker}
\alias{thinMarker,GbsrGenotypeData-method}
\title{Remove markers potentially having redundant information.}
\usage{
thinMarker(object, range = 150, ...)

\S4method{thinMarker}{GbsrGenotypeData}(object, range)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{range}{A integer value to indicate the stretch to search markers.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object with filters on markers.
}
\description{
Markers within the length of the sequenced reads
(usually ~ 150 bp, up to your sequencer)
potentially have redundant information and
those will cause unexpected errors
in error correction which assumes
independency of markers each other.
This function only retains the first marker or
the least missing rate marker
from the markers locating within the specified stretch.
}
\details{
This function search valid markers from the first marker
of each chromosome and
compare its physical position with a neighbor marker.
If the distance between those
markers are equal or less then \code{range}, one of them
which has a larger missing rate
will be removed (labeled as invalid marker).
When the first marker was retained and
the second marker was removed as invalid marker,
next the distance between the first marker
and the third marker will be checked and
this cycle is repeated until reaching the
end of each chromosome. Run \code{\link[=validMar]{validMar()}}
to check the valid SNP markers.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Summarize genotype count information to be used in thinMarker().
gds <- countGenotype(gds)
gds <- thinMarker(gds, range = 150)

closeGDS(gds) # Close the connection to the GDS file
}
