% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{pairsGBSR}
\alias{pairsGBSR}
\title{Draw a scatter plot of a pair of specified statistics}
\usage{
pairsGBSR(
  x,
  stats1 = "dp",
  stats2 = "missing",
  target = "marker",
  size = 0.5,
  alpha = 0.8,
  color = c(Marker = "darkblue", Sample = "darkblue"),
  fill = c(Marker = "skyblue", Sample = "skyblue"),
  smooth = FALSE
)
}
\arguments{
\item{x}{A \link{GbsrGenotypeData} object.}

\item{stats1}{A string to specify statistics to be drawn.}

\item{stats2}{A string to specify statistics to be drawn.}

\item{target}{Either or both of "marker" and "sample", e.g.
\code{target = "marker"} to draw a histogram only for SNPs.}

\item{size}{A numeric value to specify the dot size of a scatter plot.}

\item{alpha}{A numeric value [0-1] to specify the transparency of
dots in a scatter plot.}

\item{color}{A named vector "Marker" and "Sample" to specify border
color of bins in the histograms.}

\item{fill}{A named vector "Marker" and "Sample" to specify fill color
of bins in the histograms.\verb{stats = "geno} only requires "Ref", "Het"
and "Alt", while others uses the value named "Marker".}

\item{smooth}{A logical value to indicate whether draw a smooth line for
data points. See also \code{\link[ggplot2:geom_smooth]{ggplot2::stat_smooth()}}.}
}
\value{
A ggplot object.
}
\description{
Draw a scatter plot of a pair of specified statistics
}
\details{
You can draw a scatter plot of per-marker and/or per-sample summary
statistics specified at \code{stats1} and \code{stats2}. The "stats1" and "stats2"
arguments can take the following values:
\describe{
\item{missing}{Proportion of missing genotype calls.}
\item{het}{Proportion of heterozygote calls.}
\item{raf}{Reference allele frequency.}
\item{dp}{Total read counts.}
\item{ad_ref}{Reference allele read counts.}
\item{ad_alt}{Alternative allele read counts.}
\item{rrf}{Reference allele read frequency.}
\item{mean_ref}{Mean of reference allele read counts.}
\item{sd_ref}{Standard deviation of reference allele read counts.}
\item{median_ref}{Quantile of reference allele read counts.}
\item{mean_alt}{Mean of alternative allele read counts.}
\item{sd_alt}{Standard deviation of alternative allele read counts.}
\item{median_alt}{Quantile of alternative allele read counts.}
\item{mq}{Mapping quality.}
\item{fs}{Phred-scaled p-value (strand bias)}
\item{qd}{Variant Quality by Depth}
\item{sor}{Symmetric Odds Ratio (strand bias)}
\item{mqranksum}{Alt vs. Ref read mapping qualities}
\item{readposranksum}{Alt vs. Ref read position bias}
\item{baseqranksum}{Alt Vs. Ref base qualities}
}

To draw scatter plots for "missing", "het", "raf", you need to run
\code{\link[=countGenotype]{countGenotype()}} first to obtain statistics. Similary, "dp",
"ad_ref", "ad_alt", "rrf" requires values obtained via \code{\link[=countRead]{countRead()}}.
"mq", "fs", "qd", "sor", "mqranksum", "readposranksum",
and "baseqranksum" only work with \code{target = "marker"}, if your data
contains those values supplied via SNP calling tools like
\href{https://gatk.broadinstitute.org/hc/en-us}{GATK}.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Summarize genotype count information to be used in `pairsGBSR()`
gds <- countGenotype(gds)

# Draw scatter plots of missing rate vs heterozygosity.
pairsGBSR(gds, stats1 = "missing", stats2 = "het")

# Close the connection to the GDS file
closeGDS(gds)


}
