% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getSamID}
\alias{getSamID}
\alias{getSamID,GbsrGenotypeData-method}
\title{Obtain the sample IDs}
\usage{
getSamID(object, valid = TRUE, parents = FALSE, ...)

\S4method{getSamID}{GbsrGenotypeData}(object, valid, parents)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{valid}{A logical value. See details.}

\item{parents}{A logical value whether to include data for parents or not.}

\item{...}{Unused.}
}
\value{
A character vector of sample IDs.
}
\description{
This function returns sample IDs.
}
\details{
If \code{valid = TRUE}, the IDs of samples which are labeled \code{TRUE} in the "valid"
column of the "sample" slot will be returned. If you need the number
of over all samples, set \code{valid = FALSE}. \code{\link[=validSam]{validSam()}} tells you
which samples are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

getSamID(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
