% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getAllele}
\alias{getAllele}
\alias{getAllele,GbsrGenotypeData-method}
\title{Obtain reference allele information of markers}
\usage{
getAllele(object, valid = TRUE, chr = NULL, ...)

\S4method{getAllele}{GbsrGenotypeData}(object, valid, chr)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{valid}{A logical value. See details.}

\item{chr}{A index to spefcify chromosome to get information.}

\item{...}{Unused.}
}
\value{
A vector of strings each of which is a "/" separated string and
indicates the reference allele and the alternative allele(s) at a marker.
}
\description{
This function returns the reference allele and alternative allele(s).
}
\details{
If \code{valid = TRUE}, the alleles of markers which are labeled \code{TRUE} in the
"valid" column of the "marker" slot will be returned. If you need the number
of over all markers, set \code{valid = FALSE}. \code{\link[=validMar]{validMar()}} tells you
which markers are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

getAllele(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
