% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R,
%   R/Methods-GbsrScheme.R
\name{assignScheme}
\alias{assignScheme}
\alias{assignScheme,GbsrGenotypeData-method}
\alias{assignScheme,GbsrScheme-method}
\title{Assign member IDs to samples}
\usage{
assignScheme(object, id, ...)

\S4method{assignScheme}{GbsrGenotypeData}(object, id)

\S4method{assignScheme}{GbsrScheme}(object, id)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{id}{A numeric vector indicating member IDs to assign to samples.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object storing
a \link{GbsrScheme} object in the "scheme" slot.
}
\description{
\link{GBScleanR} uses breeding scheme information to set the expected
number of cross overs in a chromosome which is a required parameter
for the genotype error correction with the Hidden Markov model
implemented in the \code{estGeno()} function.
This function assign member IDs to indicate which samples were derived from
which pedigree that recorded in the \link{GbsrScheme} object.
}
\details{
Member IDs can be shown by \code{\link[=showScheme]{showScheme()}}. Only the member IDs assigned to
progenies (not parents) are available to assign to samples. If the last
generation recorded in the \link{GbsrScheme} object has only one member ID that
should be assigned to all samples in your population, you can omit assigning
IDs by \code{\link[=assignScheme]{assignScheme()}}. In that case, \code{\link[=estGeno]{estGeno()}} automatically assign the
only one member ID to all samples.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Biparental F2 population.
gds <- setParents(gds, parents = c("Founder1", "Founder2"))

# setParents gave member ID 1 and 2 to Founder1 and Founder2, respectively.
gds <- initScheme(gds, mating = cbind(c(1:2)))

# Now the progeny of the cross above have member ID 3.
# If `crosstype = "selfing"` or `"sibling"`, you can omit a `mating` matrix.
gds <- addScheme(gds, crosstype = "self")

# The progeny of the selfing above has member ID 4.
# To execute genotype estimation for your samples, you need to assign a member
# ID to each of the samples.

# Check IDs of samples to be assigned member IDs if necessary.
getSamID(gds)

# The assignScheme() assign member IDs `id` to the samples in order.
# Please confirm the order of the member IDs in `id` and the order of the
# sample IDs shown by getSamID(gds).
gds <- assignScheme(gds, rep(4, nsam(gds)))

# If your population has samples all of which belong to only one pedigree,
# you can omit assignScheme() and let estGeno() automatically assign the
# last member ID to all samples.

############################################################################
# Now you can execute `estGeno()` which requires a [GbsrScheme] object.

# Close the connection to the GDS file
closeGDS(gds)
}
\seealso{
\code{\link[=addScheme]{addScheme()}} and \code{\link[=showScheme]{showScheme()}}
}
