% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARS_wrapper.R
\name{GARS_GA}
\alias{GARS_GA}
\title{The wrapper fuction to use GARS}
\usage{
GARS_GA(data, classes, chr.num = 1000, chr.len, generation = 500,
  co.rate = 0.8, mut.rate = 0.01, n.elit = 10, type.sel = c("RW",
  "TS"), type.co = c("one.p", "two.p"), type.one.p.co = c("I.quart",
  "II.quart", "III.quart"), n.gen.conv = 80, plots = c("yes", "no"),
  n.Feat_plot = 10, verbose = c("yes", "no"))
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object or a matrix or
a data.frame. In case of matrix or data.frame:
\itemize{
 \item Rows and Cols have to be, respectively, observations
 and features. The variables are tipically genes;
 \item GARS also accept other -omic features as well as any
 continuous or factorial variables
 (e.g. sex, age, cholesterol level,...);
 \item Usually the number of observation is << than the number
 of features
}'}

\item{classes}{The class vector}

\item{chr.num}{The number of chromosomes to generate. Default is
1000}

\item{chr.len}{The length of chromosomes. This value corresponds
to the desired length of the feature set}

\item{generation}{The maximum number of generations. Default is 1000}

\item{co.rate}{The probability of each random couple of chromosomes
to swap some parts. It must be between 0 and 1. Default is 0.8}

\item{mut.rate}{The probability to apply a random mutation to each
element. It must be between 0 and 1. Default is 0.01}

\item{n.elit}{The number of best chromosomes to be selected by
elitism. This number must be even. Default is 10}

\item{type.sel}{The type of selection method; Roulette Wheel ("RW")
and Tournament Selection ("TS") are allowed. Default is "RW"}

\item{type.co}{The type of crossover method; one-point ("one.p")
and two-point ("two.p") are allowed. Default is "one.p"}

\item{type.one.p.co}{The position of the cromosome where performing
the crossover, if "one.p" is selected. The first quartile
 ("I.quart"), the second quartile ("II.quart", i.e. the median)
  and the third quartile ("III.quart") are allowed. Default is "I.quart"}

\item{n.gen.conv}{The number of consecutive generations with the same
maximum fitness score.}

\item{plots}{If graphs have to be plotted;
"yes" or "no" are allowed. Default is "yes"}

\item{n.Feat_plot}{The number of features to be plotted}

\item{verbose}{If statistics have to be printed;
"yes" or "no" are allowed. Default is "yes"}
}
\value{
A GarsSelectedFeatures object, containg:
\describe{
 \item{data_red}{a matrix of selected features}
 \item{last_pop}{a matrix containg the last chromosome population}
 \item{pop_list}{a list containing all the populations
  produced over the generations}
 \item{fit_list}{a numeric vector containing the maximum fitness scores,
  computed in each generation}
}
}
\description{
This function allows the users to run all GARS
funtion at once. This is the easier and recommended way to
use GARS.
}
\examples{
# use example data:
data(GARS_data_norm)
data(GARS_classes)

res_ex <- GARS_GA(GARS_data_norm,
   GARS_classes,
   chr.num = 100,
   chr.len=10,
   generation = 5,
   co.rate = 0.8,
   mut.rate = 0.1,
   n.elit = 10,
   type.sel = "RW",
   type.co ="one.p",
   type.one.p.co = "II.quart",
   n.gen.conv = 80,
   plots = "no",
   verbose = "no")

}
\author{
Mattia Chiesa, Luca Piacentini
}
