#' GARS package for a robust feature selection of high-dimensional data
#'
#' The main function of GARS is \code{\link{GARS_GA}}, which implements a
#' clustering-based Genetic Algorithm to select
#' Robust Subsets of features in high-dimensional datasets.
#'  The user can extract the results of
#'  \code{\link{GARS_GA}}, exploiting the assessor methods:
#'  \code{\link{MatrixFeatures}}, \code{\link{LastPop}},
#'  \code{\link{AllPop}} and \code{\link{FitScore}}.
#'
#' See the package vignette, by typing \code{vignette("GARS")} to discover
#' all the \code{\link{GARS_GA}} functions.
#'
#' @author Mattia Chiesa, Giada Maioli, Luca Piacentini
#'
#' @docType package
#' @name GARS
#' @aliases GARS
#' @keywords package
NULL
