% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{app}
\alias{app}
\title{Open web application}
\usage{
app(host, orgDb = NA_character_, txDb = NA_character_,
  serverName = "GA4GHshiny")
}
\arguments{
\item{host}{Character vector of an URL of GA4GH API data server endpoint.}

\item{orgDb}{character vector of an org.Db package.}

\item{txDb}{character vector of a TxDb package.}

\item{serverName}{character vector of the server name. Default: GA4GHshiny.}
}
\value{
Shiny application object.
}
\description{
Web application for interacting with GA4GH API data servers.
}
\details{
This application is dependent of which data the server provides
trough GA4GH API. If some of tables or graphic charts not appear, the server
connected may not provide the necessary data. For example, INFO data.
}
\examples{
if (interactive()) {
  library(org.Hs.eg.db)
  library(TxDb.Hsapiens.UCSC.hg19.knownGene)
  app("http://1kgenomes.ga4gh.org/", orgDb = "org.Hs.eg.db",
    txDb = "TxDb.Hsapiens.UCSC.hg19.knownGene")
}
}
