% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadVariant.R
\name{loadVariant}
\alias{loadVariant}
\title{Load Small Variant Data from VCF or MAF Files}
\usage{
loadVariant(variant_file, file_type = c("vcf", "maf"), keep_vcf_id = TRUE)
}
\arguments{
\item{variant_file}{A \code{character} string specifying the path to the
variant file, which can be in either VCF or MAF format.}

\item{file_type}{A \code{character} string specifying the type of the
input file: either \code{"vcf"} or \code{"maf"}. This parameter must be
provided. If \code{"maf"} is specified, the following columns must be
present in the MAF file: "Chromosome", "Start_Position", "Reference_Allele",
and "Tumor_Seq_Allele2".}

\item{keep_vcf_id}{A \code{logical} value indicating whether to keep the
original ID field from the VCF file in the output. Default is \code{TRUE}.}
}
\value{
A \code{GRanges} object containing the variants loaded from the
specified VCF or MAF file. For VCF files, only the \code{ID}, \code{REF},
and \code{ALT} metadata columns are included in the output. For MAF files,
all available MAF columns are retained.
}
\description{
This function loads variant data from either a standard VCF or MAF file and
filters for small variants, such as SNVs, INDELs, and DELINs.
}
\examples{
# load the vcf file, please do not forget to specify the file type
vcf_path <- system.file("extdata",
                        "example_variants_chr16.vcf",
                        package = "G4SNVHunter")
variants <- loadVariant(vcf_path, file_type = "vcf")
# load the maf file
maf_path <- system.file("extdata",
                        "example_variants_chr16.maf",
                        package = "G4SNVHunter")
variants <- loadVariant(maf_path, file_type = "maf")
}
