% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportMutG4s.R
\name{exportMutG4}
\alias{exportMutG4}
\title{Export G4s and Associated Variant Information to File}
\usage{
exportMutG4(
  mut_G4 = NULL,
  filename = NULL,
  include_metadata = TRUE,
  revcomp_G4_seq = TRUE,
  revcomp_mutG4_seq = TRUE
)
}
\arguments{
\item{mut_G4}{A \code{GRanges} object returned by \code{filterVarImpact}.
Both the \code{G4.info.sequence} and the \code{mutated.G4.seq} columns
must be included.}

\item{filename}{A \code{character} string specifying the output file path.
The file extension must be one of:
\code{.txt}, \code{.csv}, or \code{.xlsx}.}

\item{include_metadata}{A \code{logical} value.
Whether to include global metadata (e.g., G4 prediction parameters) in the
output.
Default is \code{TRUE}.}

\item{revcomp_G4_seq}{A \code{logical} value. Whether to
reverse-complement G4 sequences on the antisense (negative) strand.
Default is \code{TRUE}.}

\item{revcomp_mutG4_seq}{A \code{logical} value. Whether to
reverse-complement mutated G4 sequences on the antisense (negative) strand.
Default is \code{TRUE}.}
}
\value{
Invisibly returns a \code{data.frame} object.
}
\description{
This function exports a \code{GRanges} object containing predicted G4
regions affected by variants to a TXT, CSV, or XLSX file. The output
includes both the original and mutated G-rich sequences, along with
detailed information about the associated variants.
}
\examples{
library(GenomicRanges)
fa_path <- system.file("extdata", "seq.fa", package = "G4SNVHunter")
seq <- loadSequence(seq_path = fa_path)
# Predict G4s
G4_detected <- G4HunterDetect(seq)
# create mut granges object
mut <- data.frame(
  chr = c("seq1", "seq5"),
  pos = c(81, 11),
  ref = c("GGGTAGGG", "A"),
  alt = c("G", "AGGGGGGGGGGGGGGGG")
)

mut <- GRanges(
  seqnames = mut$chr,
  ranges = IRanges(start = mut$pos, end = mut$pos),
  strand = "*",
  ref = mut$ref,
  alt = mut$alt
)

mut_G4 <- G4VarImpact(G4_detected, mut, ref_col = "ref", alt_col = "alt")
filtered_mut_G4 <- filterVarImpact(mut_G4, score_diff_threshold = -0.2)
exportMutG4(filtered_mut_G4, "./result_mut.txt")
exportMutG4(filtered_mut_G4, "./result_mut.xlsx", include_metadata = FALSE)
exportMutG4(filtered_mut_G4, "./result_mut.csv", revcomp_mutG4_seq = FALSE)

# remove all exported files
unlink("./result_mut.txt")
unlink("./result_mut.xlsx")
unlink("./result_mut.csv")
}
