% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_deprecated.R
\name{PlotGroups}
\alias{PlotGroups}
\title{PlotGroups}
\usage{
PlotGroups(fsom, groups, threshold = NULL, pThreshold = 0.05, ...)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{BuildMST}}}

\item{groups}{Groups result as generated by \code{\link{CountGroups}}}

\item{threshold}{Relative difference in groups before the node is 
colored}

\item{pThreshold}{Threshold on p-value from wilcox-test before the 
node is colored. If this is not NULL, threshold will 
be ignored.}

\item{...}{Additional arguments to pass to \code{\link{PlotFlowSOM}}}
}
\value{
A vector containing the labels assigned to the nodes for
        all groups except the first
}
\description{
Plot differences between groups
}
\details{
Plot FlowSOM trees, where each node is represented by 
a star chart indicating mean marker values, the size of the node is relative
to the mean percentage of cells present in each
}
\examples{
#Run FlowSOM
fileName <-  system.file("extdata", "68983.fcs", package="FlowSOM")
fsom <- FlowSOM(fileName, compensate = TRUE, transform = TRUE,
                      scale = TRUE, colsToUse = c(9,12,14:18), nClus = 10)

ff <- flowCore::read.FCS(fileName)
# Make an additional file without cluster 7 and double amount of cluster 5
selection <- c(which(GetClusters(fsom) \%in\% which(fsom$metaclustering != 7)),
                 which(GetClusters(fsom) \%in\% which(fsom$metaclustering == 5)))
ff_tmp <- ff[selection,]
flowCore::write.FCS(ff_tmp, file="ff_tmp.fcs")

# Compare only the file with the double amount of cluster 10
features <- GetFeatures(fsom, 
                        c(fileName, "ff_tmp.fcs"),
                        level = "clusters",
                        type = "percentages")
stats <- GroupStats(features$cluster_percentages,                     
                    groups = list("AllCells" = c(fileName),
                                  "Without_ydTcells" = c("ff_tmp.fcs")))

fold_changes <- stats["fold changes", ]
fold_changes_label <- factor(ifelse(fold_changes < -1.5, 
                           "Underrepresented compared to Group 1",
                           ifelse(fold_changes > 1.5, 
                                  "Overrepresented compared to Group 1",
                                  "--")), 
                            levels = c("--", 
                               "Underrepresented compared to Group 1",
                               "Overrepresented compared to Group 1"))
fold_changes_label[is.na(fold_changes_label)] <- "--"                                   
gr_1 <- PlotStars(fsom, 
                  title = "All Cells", 
                  nodeSizes = stats["medians AllCells", ], 
                  list_insteadof_ggarrange = TRUE)
gr_2 <- PlotStars(fsom, title = "Group 2", 
               nodeSizes = stats["medians Without_ydTcells", ], 
                backgroundValues = fold_changes_label,
               backgroundColors = c("white", "red", "blue"), 
               list_insteadof_ggarrange = TRUE)
p <- ggpubr::ggarrange(plotlist = c(list(gr_1$tree), gr_2),
                    heights = c(3, 1))
p                   
         
}
\seealso{
\code{\link{PlotStars}},\code{\link{PlotVariable}},
\code{\link{PlotFlowSOM}},\code{\link{PlotLabels}},\code{\link{PlotNumbers}},
\code{\link{PlotMarker}},\code{\link{PlotPies}},\code{\link{QueryStarPlot}},
\code{\link{PlotSD}}
}
