% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliar.R
\name{check_encoding}
\alias{check_encoding}
\title{Check quality encoding}
\usage{
check_encoding(x = NULL, custom = NULL)
}
\arguments{
\item{x}{Quality values}

\item{custom}{custom encoding from the following:

'Sanger' --------> expected range: [0, 40]

'Illumina1.8' --------> expected range: [0, 41]

'Illumina1.5' --------> expected range: [0, 40]

'Illumina1.3' --------> expected range: [3, 40]

'Solexa' --------> expected range: [-5, 40]}
}
\value{
List with encoding information
}
\description{
Check quality encoding
}
\examples{

require(Biostrings)

x <- list(PhredQuality(0:40), SolexaQuality(-5:40), IlluminaQuality(3:40))
x <- lapply(x, function(i)utf8ToInt(as.character(i)[1]))
lapply(x, check_encoding)
 
SolexaQuality(0:40)
IlluminaQuality(0:40)
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
