% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{subset.FRASER}
\alias{subset.FRASER}
\alias{[,FraserDataSet,ANY,ANY,ANY-method}
\title{Subsetting by indices for junctions}
\usage{
\method{subset}{FRASER}(x, i, j, by = c("j", "ss"), ..., drop = FALSE)

\S4method{[}{FraserDataSet,ANY,ANY,ANY}(x, i, j, by = c("j", "ss"), ..., drop = FALSE)
}
\arguments{
\item{x}{A \code{FraserDataSet} object}

\item{i}{A integer vector to subset the rows/ranges}

\item{j}{A integer vector to subset the columns/samples}

\item{by}{a character (j or ss) defining if we subset by
junctions or splice sites}

\item{...}{Parameters currently not used or passed on}

\item{drop}{No dimension reduction is done. And the \code{drop}
parameter is currently not used at all.}
}
\value{
A subsetted \code{FraserDataSet} object
}
\description{
Providing subsetting by indices through the single-bracket operator
}
\examples{
    fds <- createTestFraserDataSet()
    fds[1:10,2:3]
    fds[,samples(fds) \%in\% c("sample1", "sample2")]
    fds[1:10,by="ss"]

}
