% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FraserDataSet-class.R
\name{FraserDataSet}
\alias{FraserDataSet}
\title{The FRASER dataset object}
\usage{
FraserDataSet(colData = NULL, junctions = NULL, spliceSites = NULL, ...)
}
\arguments{
\item{colData}{A DataFrame containing the annotation of the samples}

\item{junctions, spliceSites}{A data.frame like object containing the 
raw counts for each junction or splice site.
It requires the columns \code{startID} and \code{endID} for 
the junctions and \code{spliceSiteID} and \code{type} for the
splice sites. Those columns identifies the corresponding
splice site for the given junction and map to the splice site.
For each sample the counts are saved in a corresponding 
column with the same name. It can also be a GRange object.}

\item{...}{Any parameters corresponding to the slots and their possible
values. See \linkS4class{FraserDataSet}}
}
\value{
A FraserDataSet object.
}
\description{
Constructs an FRASER object based on the given input. It can take only the
annotation (colData) or count tables (junctions/spliceSites).
}
\examples{
  fraser <- FraserDataSet()
  
  # example sample annoation
  sampleTable <- data.table::fread(system.file("extdata",
          "sampleTable_countTable.tsv", package="FRASER", mustWork=TRUE))
 
  # get raw counts 
  junctionCts   <- data.table::fread(system.file("extdata",
          "raw_junction_counts.tsv.gz", package="FRASER", mustWork=TRUE))
  spliceSiteCts <- data.table::fread(system.file("extdata",
          "raw_site_counts.tsv.gz", package="FRASER", mustWork=TRUE))
  
  # create FRASER object
  fds <- FraserDataSet(colData=sampleTable, junctions=junctionCts,
          spliceSites=spliceSiteCts, name="Example Dataset")
  
}
\author{
Christian Mertes \email{mertes@in.tum.de}
}
