% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_mutations.R
\name{sc_mutations}
\alias{sc_mutations}
\title{Variant count for single-cell data}
\usage{
sc_mutations(bam_path, seqnames, positions, indel = FALSE, threads = 1)
}
\arguments{
\item{bam_path}{character(1) or character(n): path to the bam file(s) aligned to the
reference genome (NOT the transcriptome! Unless the postions are also from the transcriptome).}

\item{seqnames}{character(n): chromosome names of the postions to count alleles.}

\item{positions}{integer(n): positions, 1-based, same length as seqnames. The positions to count alleles.}

\item{indel}{logical(1): whether to count indels (TRUE) or SNPs (FALSE).}

\item{threads}{integer(1): number of threads to use. Maximum number of threads is
the number of bam files * number of positions.}
}
\value{
A tibble with columns: allele, barcode, allele_count, cell_total_reads, pct, pos, seqname.
}
\description{
Count the number of reads supporting each variants at the given positions for each cell.
}
\examples{
ppl <- example_pipeline("SingleCellPipeline")
ppl <- run_step(ppl, "barcode_demultiplex")
ppl <- run_step(ppl, "genome_alignment")
snps_tb <- sc_mutations(
  bam_path = ppl@genome_bam,
  seqnames = c("chr14", "chr14"),
  positions = c(1260, 2714), # positions of interest
  indel = FALSE
)
head(snps_tb)
snps_tb |>
  dplyr::filter(pos == 1260) |>
  dplyr::group_by(allele) |>
  dplyr::summarise(count = sum(allele_count)) # should be identical to samtools pileup
}
