% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_DTU_analysis.R
\name{sc_DTU_analysis}
\alias{sc_DTU_analysis}
\title{FLAMES Differential Transcript Usage Analysis}
\usage{
sc_DTU_analysis(
  sce,
  gene_col = "gene_id",
  min_count = 15,
  threads = 1,
  method = "trascript usage permutation",
  permuations = 1000
)
}
\arguments{
\item{sce}{The \code{SingleCellExperiment} object, with transcript counts
in the \code{counts} slot and cluster labels in the \code{colLabels} slot.}

\item{gene_col}{The column name in the \code{rowData} slot of \code{sce}
that contains the gene ID / name. Default is \code{"gene_id"}.}

\item{min_count}{The minimum total counts for a transcript to be tested.}

\item{threads}{Number of threads to use for parallel processing.}

\item{method}{The method to use for testing, listed in \code{details}.}

\item{permuations}{Number of permutations for permutation methods.}
}
\value{
a \code{tibble} containing the following columns:
\describe{
 \item{p.value}{ - the raw p-value }
 \item{adj.p.value}{ - multiple testing adjusted p-value }
 \item{cluster}{ - the cluster where DTU was observed }
 \item{transcript}{ - rowname of \code{sce}, the DTU isoform }
 \item{transcript_usage}{ - the transcript usage of the isoform in the cluster }
}
Additional columns from \code{method = "trascript usage permutation"}:
\describe{
 \item{transcript_usage_elsewhere}{ - transcript usage in other clusters }
 \item{usage_difference}{ - the difference between the two transcript usage }
 \item{permuted_var}{ - the variance of usage difference in the permuted data }
}
Additional columns from \code{method = "chisq"}:
\describe{
 \item{X_value}{ - the test statistic }
 \item{df}{ - the degrees of freedom }
 \item{expected_usage}{ - the expected usage (mean across all clusters) }
 \item{usage_difference}{ - the difference between the observed and expected usage }
}
The table is sorted by P-values.
}
\description{
Differential transcription usage testing for single cell data, using
\code{colLabels} as cluster labels.
}
\details{
Genes with more than 2 isoforms expressing more than \code{min_count} counts
are selected for testing with one of the following methods:
\describe{
 \item{trascript usage permutation}{ Transcript usage are taken as the test statistic, cluster labels are permuted to generate a null distribution.}
 \item{chisq}{ Chi-square test of the transcript count matrix for each gene. }
}
Adjusted P-values were calculated by Benjamini–Hochberg correction.
}
\examples{
outdir <- tempfile()
dir.create(outdir)
bc_allow <- file.path(outdir, "bc_allow.tsv")
genome_fa <- file.path(outdir, "rps24.fa")
R.utils::gunzip(
  filename = system.file("extdata", "bc_allow.tsv.gz", package = "FLAMES"),
  destname = bc_allow, remove = FALSE
)
R.utils::gunzip(
  filename = system.file("extdata", "rps24.fa.gz", package = "FLAMES"),
  destname = genome_fa, remove = FALSE
)

sce <- FLAMES::sc_long_pipeline(
  genome_fa = genome_fa,
  fastq = system.file("extdata", "fastq", "musc_rps24.fastq.gz", package = "FLAMES"),
  annotation = system.file("extdata", "rps24.gtf.gz", package = "FLAMES"),
  outdir = outdir,
  barcodes_file = bc_allow,
  config_file = create_config(
    outdir,
    pipeline_parameters.demultiplexer = "flexiplex"
  )
)
group_anno <- data.frame(barcode_seq = colnames(sce), groups = SingleCellExperiment::counts(sce)["ENSMUST00000169826.2", ] > 1)
SingleCellExperiment::colLabels(sce) <- group_anno$groups
# DTU with permutation testing:
sc_DTU_analysis(sce, min_count = 1, method = "trascript usage permutation")
# now try with chisq:
sc_DTU_analysis(sce, min_count = 1, method = "chisq")
}
