% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindPrimers.R
\name{FindPrimers}
\alias{FindPrimers}
\title{FindPrimers}
\usage{
FindPrimers(
  SG,
  EventNum,
  Primer3Path,
  Dir,
  mygenomesequence,
  taqman = NA,
  nProbes = 1,
  nPrimerstwo = 3,
  ncommonForward = 3,
  ncommonReverse = 3,
  nExons = 5,
  nPrimers = 15,
  shortdistpenalty = 2000,
  maxLength = 1000,
  minsep = 100,
  wminsep = 200,
  valuethreePenalty = 1000,
  minexonlength = 25,
  wnpaths = 200,
  qualityfilter = 5000
)
}
\arguments{
\item{SG}{Information of the graph of the gene where the selected event belongs.
This information is avaible in the output of EventDetection_transcriptome function.}

\item{EventNum}{The "EventNum" variable can be found in the returned .txt file from
the EventDetection_transcriptome function in the column "EventNumber" or in the output of  EventPointer_RNASeq_TranRef,
the number after the "_" character of the 'Event_ID'.}

\item{Primer3Path}{Complete path where primer3_core.exe is placed.}

\item{Dir}{Complete path where primer3web_v4_0_0_default_settings.txt file and primer3_config directory are stored.}

\item{mygenomesequence}{genome sequence of reference}

\item{taqman}{TRUE if you want to get probes and primers for taqman. FALSE if you want to get primers for conventional PCR.}

\item{nProbes}{Number of probes for Taqman experiments. By default 1.}

\item{nPrimerstwo}{Number of potential exon locations for primers using
two primers (one forward and one reverse). By default 3.}

\item{ncommonForward}{Number of potential exon locations for primers using
one primer in forward and two in reverse. By default 3.}

\item{ncommonReverse}{Number of potential exon locations for primers using 
two primer in forward and one in reverse. By default 3.}

\item{nExons}{Number of combinations of ways to place primers in exons to 
interrogate an event after sorting. By default 5.}

\item{nPrimers}{Once the exons are selected, number of primers combination sequences to search within the whole set of potential sequences.
By default 5.}

\item{shortdistpenalty}{Penalty for short exons following an exponential funciton(A * exp(-dist * shortdistpenalty)).
By defautl 2000.}

\item{maxLength}{Max length of exons that are between primers and for paths once we have calculated the sequence.
By default 1000.}

\item{minsep}{Distance from which it is penalized primers for being too close
By default 100.}

\item{wminsep}{Weigh of the penalization to primers for being too close
By default 200.}

\item{valuethreePenalty}{penalization for cases that need three primers instead of 2.
By default 1000.}

\item{minexonlength}{Minimum length that a exon has to have to be able to contain a primer.
By default 25.}

\item{wnpaths}{Penalty for each existing path
By default 200.}

\item{qualityfilter}{Results will show as maximum 3 combinations with a punctuation higher than qualityfilter
By default 5000.}
}
\value{
The output of the function is a `data.frame` whose columns are:

For1Seq: Sequence of the first forward primer.

For2Seq: Sequence of the second forward primer in case it is needed.

Rev1Seq: Sequence of the first reverse primer.

Rev2Seq: Sequence of the second reverse primer in case it is needed.

For1Exon: Name of the exon of the first forward primer.

For2Exon: Name of the exon of the second forward primer in case it is needed.

Rev1Exon: Name of the exon of the first reverse primer.

Rev2Exon: Name of the exon of the second reverse primer in case it is needed.

FINALvalue: Final punctuation for that combination of exons and sequences. The lower it is this score, the better it is the combination. 

DistPath1: Distances of the bands, in base pairs, that interrogate Path1  when we perform the conventional PCR experiment.

DistPath2: Distances of the bands, in base pairs, that interrogate Path2 `when we perform the conventional PCR experiment.

DistNoPath: Distances of the bands, in base pairs, that they do not interrogate any of the two paths when we perform the conventional PCR experiment.

SeqProbeRef: Sequence of the TaqMan probe placed in the Reference.

SeqProbeP1: Sequence of the TaqMan probe placed in the Path1.

SeqProbeP2: Sequence of the TaqMan probe placed in the Path2.
}
\description{
FindPrimers is the main function of the primers design option.
The aim of this function is the design of PCR primers and 
TaqMan probes for detection and quantification of alternative splicing.

Depending on the assay we want to carry out the the algorithm will design 
the primers for a conventional PCR or the primers and TaqMan 
probes if we are performing a TaqMan assay.

In the case of a conventional PCR we will be able to detect the alternative
 splicing event. Besides, the algorithm gives as an output the length of the PCR
 bands that are going to appear. In the case of a TaqMan assay, we will not only
 detect but also quantify alternative splicing.
}
\examples{
\dontrun{

data("EventXtrans")
#From the output of EventsGTFfromTranscriptomeGTF we take the splicing graph information
SG_list <- EventXtrans$SG_List
#SG_list contains the information of the splicing graphs for each gene

#Let's supone we want to design primers for the event 1 of the gene ENSG00000254709.7 

#We take the splicing graph information of the required gene
SG <- SG_list$ENSG00000254709.7 

#We point the event number
EventNum <- 1

#Define rest of variables:
Primer3Path <- Sys.which("primer3_core")
Dir <- "C:\\\\PROGRA~2\\\\primer3\\\\"

MyPrimers <- FindPrimers(SG = SG,
                         EventNum = EventNum,
                         Primer3Path = Primer3Path,
                         Dir = Dir,
                         mygenomesequence = BSgenome.Hsapiens.UCSC.hg38::Hsapiens,
                         taqman = 1,
                         nProbes=1,
                         nPrimerstwo=4,
                         ncommonForward=4,
                         ncommonReverse=4,
                         nExons=10, 
                         nPrimers =5,
                         maxLength = 1200)  


}

}
