% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_power_cont.R
\name{get_power_cont}
\alias{get_power_cont}
\title{Power Calculations for Continuous EWAS}
\usage{
get_power_cont(
  dm,
  Total,
  n,
  fdr_fwer,
  rho_mu,
  rho_sd = 0,
  Tissue = "Saliva",
  Nmax = 1000,
  MOE = 0.03,
  test = "pearson",
  use_fdr = TRUE,
  det_limit = 0.03,
  Suppress_updates = FALSE,
  emp_data = NULL,
  phenotype_data = NULL
)
}
\arguments{
\item{dm}{Number of non-null tests.}

\item{Total}{The total number of tests (null and non-null).}

\item{n}{Sample size(s) for which power is calculated (accepts a vector).}

\item{fdr_fwer}{Either the false discovery rate or the family-wise type I
error rate, depending on \code{use_fdr}.}

\item{rho_mu}{Mean correlation(s) of methylation and phenotype for non-null
tests (accepts a vector). If multiple \code{n} and \code{rho_mu} are specified, power
is calculated for all unique settings under the Cartesian product of these
vectors.}

\item{rho_sd}{Standard deviation of methylation and phenotype for non-null
tests. If 0 all correlations are fixed at \code{rho_mu}.}

\item{Tissue}{Tissue type of Empirical EWAS to be used for data generation
(see details for valid options).}

\item{Nmax}{The maximum number of datasets used to calculate power}

\item{MOE}{The target margin of error of a 95\% confidence interval
for average power. This determines the stopping point of the algorithm.}

\item{test}{The type of statistical test to be used. \code{"pearson"},
\code{"kendall"} and \code{"spearman"} are valid options.}

\item{use_fdr}{If \code{TRUE}, uses \code{fdr_fwer} as the false discovery rate.
If \code{FALSE}, uses the family-wise type I error rate.}

\item{det_limit}{The minimum absolute correlation for the effect size
distribution. Ignored if \code{rho_sd=0}.}

\item{Suppress_updates}{If \code{TRUE}, blocks messages reporting the completion
of each unique setting.}

\item{emp_data}{Reference data set in matrix or data frame format (Beta
values with CpG sites as rows, samples as columns). Ignored unless
\code{Tissue="Custom"}.}

\item{phenotype_data}{A sample of phenotype data to be used in the power
calculation(s). Accepts a vector with length > 100, although we recommend
that users make this at least as large as their maximum sample size.
If left blank, a normal distribution is used to generate correlations.}
}
\value{
A data frame with rows equal to the number of \code{n} and \code{rho_mu}
combinations
}
\description{
Calculates power for EWAS with a continuous outcome for multiple
sample sizes and/or correlations based on Barth and Reynolds (2025). Data
sets are only simulated for the non-null tests; p-values are generated
directly for the null tests. Rather than specifying the number of data sets
to calculate power, you specify the precision level (\code{MOE})
and a maximum number of data sets (\code{Nmax}). After 20 data sets, the
function terminates when the desired precision level is reached or if the
number of tested data sets reaches \code{Nmax}.
}
\details{
Valid options for the \code{Tissue} argument are \code{"Saliva"}, \code{"Lymphoma"},
\code{"Placenta"}, \code{"Liver"}, \code{"Colon"}, \code{"Blood adult"}, \code{"Blood 5 year olds"},
\code{"Blood newborns"}, \code{"Cord-blood (whole blood)"}, \code{"Cord-blood (PBMC)"},
\code{"Adult (PBMC)"}, and \code{"Sperm"}. All data sets are publicly available on the
gene expression omnibus (see
\href{https://github.com/jbarth216/EpipwR.data}{EpipwR.data} package for
more details) and were identified by Graw, et. al. (2019). Please note that,
due to some extreme values in this data, the Lymphoma option will
occasionally throw a warning related to data generation. At this time, we
recommend using one of the other tissue options. Users who would like to use
their own reference data set should set \code{Tissue="Custom"} and provide the
data in matrix or data frame format with \code{emp_data}. Similarly, users can
also now specify their own phenotype data, either from a real data set or by
generating samples from a known distribution (i.e., \code{rt(1000,2)}). Users who
would like to take advantage of either of these settings are responsible for
the quality and formatting of the data provided.

Although this function only covers 3 types of statistical tests, its worth
noting that tests run using software packages such as limma will yield the
same results as a pearson correlation test in the absence of covariates
or any dependence across CpG sites (as is the assumption here).
Any users wanting to mimic an analysis done in limma should use
\code{test="pearson"}.
}
\examples{
# This examples calculates power for 100 non-null tests out of 10,000 total
# with an FDR of 5\%.
# Sample sizes of 70,80,90,100 and fixed correlations at 0.3,0.4,0.5 are
# used.
get_power_cont(100,10000,c(70,80,90,100),.05,c(.3,.4,.5))
}
\references{
Barth, J., and Reynolds, A. W. (2025). EpipwR: Efficient power
analysis for EWAS with continuous outcomes. \emph{Bioinformatics Advances},
5(1), vbaf150.

Graw, S., Henn, R., Thompson, J. A., and Koestler, D. C. (2019).
pwrEWAS: A user-friendly tool for comprehensive power estimation for
epigenome wide association studies (EWAS). \emph{BMC Bioinformatics},
20(1):218.
}
