% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/shiftGenomicToTranscript.R
\name{shiftTranscriptToGenomic}
\alias{shiftTranscriptToGenomic}
\alias{shiftGenomicToTranscript}
\alias{shiftTranscriptToGenomic,GRanges,GRangesList-method}
\alias{shiftTranscriptToGenomic,GRangesList,GRangesList-method}
\alias{shiftGenomicToTranscript,GRanges,GRangesList-method}
\alias{shiftGenomicToTranscript,GRangesList,GRangesList-method}
\title{Shift \code{GRanges} coordinates based on another \code{GRanges}
object}
\usage{
shiftTranscriptToGenomic(subject, tx)

shiftGenomicToTranscript(subject, tx)

\S4method{shiftTranscriptToGenomic}{GRanges,GRangesList}(subject, tx)

\S4method{shiftTranscriptToGenomic}{GRangesList,GRangesList}(subject, tx)

\S4method{shiftGenomicToTranscript}{GRanges,GRangesList}(subject, tx)

\S4method{shiftGenomicToTranscript}{GRangesList,GRangesList}(subject, tx)
}
\arguments{
\item{subject}{a \code{\link[GenomicRanges:GRanges-class]{GRanges}} or
\code{\link[GenomicRanges:GRangesList-class]{GRangesList}} object}

\item{tx}{a named \code{\link[GenomicRanges:GRangesList-class]{GRangesList}}
object.}
}
\value{
a \code{\link[GenomicRanges:GRanges-class]{GRanges}} or
  \code{\link[GenomicRanges:GRangesList-class]{GRangesList}} object depending
  on the type of \code{subject}
}
\description{
\code{shiftGenomicToTranscript} shifts positions of a
\code{\link[GenomicRanges:GRanges-class]{GRanges}}
object based on coordinates of another \code{GRanges} object. The most common
application is to shift genomic coordinates to transcript coordinates, which
is reflected in the name. \code{shiftTranscriptToGenomic} implements the
reverse operation.

Matches are determined by
\code{\link[GenomicRanges:findOverlaps-methods]{findOverlaps}} for
\code{shiftGenomicToTranscript} and by
\code{\link[S4Vectors:Vector-comparison]{findMatches}} for
\code{shiftTranscriptToGenomic} using the \code{seqnames} of the
\code{subject} and the \code{names} of \code{tx}.
}
\examples{
library(GenomicRanges)
# Construct some example data
subject1 <- GRanges("chr1", IRanges(3, 6),
                    strand = "+")
subject2 <- GRanges("chr1", IRanges(c(17,23), width=3),
                    strand = c("+","-"))
subject3 <- GRanges("chr2", IRanges(c(51, 54), c(53, 59)),
                    strand = "-")
subject <- GRangesList(a=subject1, b=subject2, c=subject3)
tx1 <- GRanges("chr1", IRanges(1, 40),
               strand="+")
tx2 <- GRanges("chr1", IRanges(10, 30),
               strand="+")
tx3 <- GRanges("chr2", IRanges(50, 60),
               strand="-")
tx <- GRangesList(a=tx1, b=tx2, c=tx3)

# shift to transcript coordinates. Since the third subject does not have
# a match in tx it is dropped with a warning
shifted_grl <- shiftGenomicToTranscript(subject,tx)

# ... and back
shifted_grl2 <- shiftTranscriptToGenomic(shifted_grl,tx)

# comparison of ranges work. However the seqlevels differ
ranges(shifted_grl2) == ranges(subject[list(1,c(1,1),c(1,2))])
}
