% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeEpiTxDbFromGRanges.R
\name{makeEpiTxDbFromGRanges}
\alias{makeEpiTxDbFromGRanges}
\title{Create a \code{EpiTxDb} object from a \code{GRanges} object}
\usage{
makeEpiTxDbFromGRanges(gr, metadata = NULL, reassign.ids = FALSE)
}
\arguments{
\item{gr}{A \code{\link[GenomicRanges:GRanges-class]{GRanges}} object, which
contains at least the mandatory columns.}

\item{metadata}{A 2-column \code{data.frame} containing meta information to
be included in the \code{EpiTxDb} object. This \code{data.frame} is just
passed to \code{\link[=makeEpiTxDb]{makeEpiTxDb}}. See
\code{\link[=makeEpiTxDb]{makeEpiTxDb}} for more information about the format
of metadata. (default: \code{metadata = NULL})}

\item{reassign.ids}{= FALSE}
}
\value{
a \code{EpiTxDb} object.
}
\description{
\code{makeEpiTxDbFromGRanges} extracts informations from a
\code{\link[GenomicRanges:GRanges-class]{GRanges}} object. The following
metadata columns can be used:
\itemize{
\item \code{mod_id}, \code{mod_type}, \code{mod_name} and \code{tx_ensembl}.
The first three are mandatory, whereas \code{tx_ensembl} is optional.
\item \code{rx_genename}, \code{rx_rank}, \code{rx_ensembl},
\code{rx_ensembltrans} and \code{rx_entrezid}
\item \code{spec_type}, \code{spec_genename}, \code{spec_ensembl},
\code{spec_ensembltrans} and \code{spec_entrezid}
\item \code{ref_type} and \code{ref}
}
... and passed on the \code{\link[=makeEpiTxDb]{makeEpiTxDb}}.
}
\examples{
library(GenomicRanges)
gr <- GRanges(seqnames = "test",
              ranges = IRanges::IRanges(1,1),
              strand = "+",
              DataFrame(mod_id = 1L,
                        mod_type = "Am",
                        mod_name = "Am_1"))
etdb <- makeEpiTxDbFromGRanges(gr)
}
