% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{encode_H3K27ac}
\alias{encode_H3K27ac}
\title{Example ChIP-seq peak file}
\format{
An object of class \code{GRanges} of length 5142.
}
\source{
The code to prepare the .Rda file from the raw peak file is:

\code{# dataset was directly downloaded from} \cr
\code{# https://www.encodeproject.org/files/ENCFF044JNJ/}
\code{encode_H3K27ac <- ChIPseeker::readPeakFile("path", as = "GRanges")} \cr
\code{encode_H3K27ac <- 
encode_H3K27ac[seqnames(encode_H3K27ac) == "chr1"]} \cr
\code{my_label <-
 c("name","score","strand","signalValue","pValue","qValue","peak")} \cr
\code{colnames(GenomicRanges::mcols(encode_H3K27ac)) <- my_label} \cr
\code{usethis::use_data(encode_H3K27ac, overwrite = TRUE)} \cr
}
\usage{
data("encode_H3K27ac")
}
\description{
Human H3K27ac peak file generated with ChIP-seq using K562 cell-line.
Human genome build hg19 was used.
The peak file (.BED) was obtained from ENCODE project
(\url{https://www.encodeproject.org/files/ENCFF044JNJ/}).
The BED file was then imported as an GRanges object.
Peaks located on chromosome 1 were subsetted to reduce the dataset size.
}
\keyword{datasets}
