% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schematic.plot.R
\name{schematic.plot}
\alias{schematic.plot}
\title{schematic.plot to plot schematic plots showing the locations of genes and probes.}
\usage{
schematic.plot(data,
               group.col = NULL,
               group1 = NULL,
               group2 = NULL,
               pair,
               byProbe,
               byGeneID,
               byCoordinate=list(chr=c(), start=c(), end=c()),
               statehub.tracks,
               dir.out="./",
               save=TRUE,...)
}
\arguments{
\item{data}{A Multi Assay Experiment object with DNA methylation and
gene expression Summarized Experiment objects}

\item{group.col}{A column defining the groups of the sample. You can view the
available columns using: colnames(MultiAssayExperiment::colData(data)).}

\item{group1}{A group from group.col. ELMER will run group1 vs group2.
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.}

\item{group2}{A group from group.col. ELMER will run group1 vs group2.
That means, if direction is hyper, get probes
hypermethylated in group 1 compared to group 2.#' @param byProbe A vector of probe names.}

\item{pair}{A data frame with three columns: Probe, Gene ID (Ensemble gene ID)
and Pe (empirical p-value). This is the ouput of get.pair function.}

\item{byProbe}{A vector of probe names}

\item{byGeneID}{A vector of gene ID}

\item{byCoordinate}{A list contains chr, start and end.
byCoordinate=list(chr=c(),start=c(),end=c()).}

\item{statehub.tracks}{Relative path to a statehub track.}

\item{dir.out}{A path specify the directory for outputs. Default is current directory}

\item{save}{A logic. If true, figures will be saved to dir.out.}

\item{...}{Parameters for GetNearGenes}
}
\description{
schematic.plot is a function to plot schematic plots showing the locations of genes and probes.
}
\details{
byProbes:
 When a vector of probes' name are provided,
 function will produce schematic plots for each individual probes.
 The schematic plot contains probe, nearby 20 (or the number of gene user specified.)
 genes and the significantly linked gene to the probe.

byGene:
 When a vector of gene ID are provided, function will produce schematic plots
 for each individual genes. The schematic plot contains the gene and all the
 significantly linked probes.

byCoordinate:
 When a genomic coordinate is provided, function will
 produce a schematic plot for this coordinate. The schematic plot contains
 all genes and significantly linked probes in the range and the significant links.
}
\examples{
data <- ELMER:::getdata("elmer.data.example")
pair <- data.frame(Probe = c("cg19403323","cg19403323", "cg26403223"),
                   GeneID = c("ENSG00000196878", "ENSG00000009790", "ENSG00000009790" ),
                   Symbol = c("TRAF3IP3","LAMB3","LAMB3"),
                   Raw.p =c(0.001,0.00001,0.001),
                   Pe = c(0.001,0.00001,0.001))
schematic.plot(data,
               group.col = "definition",
               group1 = "Primary solid Tumor",
               group2 = "Solid Tissue Normal",
               pair = pair,
               byProbe = "cg19403323")
schematic.plot(data,
               group.col = "definition",
               group1 = "Primary solid Tumor",
               group2 = "Solid Tissue Normal",
               pair = pair,
               byGeneID = "ENSG00000009790")

schematic.plot(data,
               group.col = "definition",
               group1 = "Primary solid Tumor",
               group2 = "Solid Tissue Normal",
               pair = pair,
               byCoordinate = list(chr="chr1", start = 209000000, end = 209960000))
\dontrun{
   schematic.plot(data,
                  group.col = "definition",
                  group1 = "Primary solid Tumor",
                  group2 = "Solid Tissue Normal",
                  pair = pair,
                  byProbe = "cg19403323",
                  statehub.tracks = "hg38/ENCODE/mcf-7.16mark.segmentation.bed")
}
}
