% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetNearbyGenes.R
\name{getRegionNearGenes}
\alias{getRegionNearGenes}
\title{Identifies nearest genes to a region}
\usage{
getRegionNearGenes(
  TRange = NULL,
  numFlankingGenes = 20,
  geneAnnot = NULL,
  tssAnnot = NULL
)
}
\arguments{
\item{TRange}{A GRange object contains coordinate of targets.}

\item{numFlankingGenes}{A number determine how many gene will be collected from each}

\item{geneAnnot}{A GRange object contains gene coordinates of for human genome.}

\item{tssAnnot}{A GRange object contains tss coordinates of for human genome.}
}
\value{
A data frame of nearby genes and information: genes' IDs, genes' symbols,
}
\description{
Auxiliary function for GetNearGenes
 This will get the closest genes (n=numFlankingGenes) for a target region (TRange)
 based on a genome of refenrece gene annotation (geneAnnot). If the
 transcript level annotation (tssAnnot) is provided the Distance will be updated to
 the distance to the nearest TSS.
}
\examples{
geneAnnot <-  ELMER:::get.GRCh("hg38",as.granges = TRUE)
tssAnnot <-  getTSS(genome = "hg38")
probe <- GenomicRanges::GRanges(seqnames = c("chr1","chr2"), 
range=IRanges::IRanges(start = c(16058489,236417627), end= c(16058489,236417627)), 
name= c("cg18108049","cg17125141"))
names(probe) <- c("cg18108049","cg17125141")
NearbyGenes <- getRegionNearGenes(numFlankingGenes = 20,
                             geneAnnot = geneAnnot,
                             TRange = probe,
                             tssAnnot = tssAnnot)
}
\author{
Tiago C Silva (maintainer: tiagochst@usp.br)
}
