% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuplexTrack.R
\name{availableDisplayPars}
\alias{availableDisplayPars}
\title{The default display parameters for a  \code{DuplexTrack} object}
\usage{
availableDisplayPars(class)
}
\arguments{
\item{class}{\code{DuplexTrack} track object
This function allows user to display the
default display parameters for the \code{DuplexTrack} class.}
}
\value{
list of the default display parameters.
}
\description{
\code{DuplexTrack} inherits from \verb{[Gviz::Annotaiontrack()]} and its Gviz parents.
Most likely, user doesn't need all dioplay pars for the parents, so only
parameters relevant to the \code{DuplexTrack} are returned by default.
}
\examples{
library(InteractionSet)
anchor1 <- GRanges(
    seqnames = "chr1",
    ranges = IRanges(
        start = c(100, 600, 1100, 1600, 2100),
        end = c(200, 700, 1200, 1700, 2200)
    ),
    strand = "+"
)
anchor2 <- GRanges(
    seqnames = "chr1",
    ranges = IRanges(
        start = c(300, 800, 1300, 1800, 2300),
        end = c(400, 900, 1400, 1900, 2400)
    ),
    strand = "+"
)

interactions <- GInteractions(anchor1, anchor2, mode = "strict")
gr_region <- range(anchor1, anchor2)
a <- DuplexTrack(interactions, gr_region = gr_region, stacking = "dense")
availableDisplayPars("DuplexTrack")
DuplexDiscovereR::availableDisplayPars(a)
}
