% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{NMIs}
\alias{NMIs}
\title{NMI Matrix}
\usage{
NMIs(clusMat, unclustered = NULL)
}
\arguments{
\item{clusMat}{The clustering matrix with a row per cell and a column per
clustering label type}

\item{unclustered}{The value assigned to unclustered cells. Default to \code{NULL}}
}
\value{
The NMI matrix
}
\description{
NMI Matrix
}
\details{
In the NMI matrix where each cell \strong{i,j} is the normalized mutual
information between columns \strong{i} and \strong{j} of the original \code{clusMat}.
If \code{unclustered} is not NULL, the cells which have been assigned to the
\code{unclustered} cluster will not be counted towards computing the NMI.
}
\examples{
data("clusMat", package = "Dune")
NMIs(clusMat)
}
