% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_ASV_OTUID.R
\name{summ_ASV_OTUID}
\alias{summ_ASV_OTUID}
\title{Summarize ASV Data Based on ASV_ID}
\usage{
summ_ASV_OTUID(obj)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing ASV abundance data.}
}
\value{
A data frame containing summary statistics for each ASV.
}
\description{
This function generates summary statistics (mean, median, standard deviation,
standard error, and quantiles) for each ASV (Amplicon Sequence Variant)
in a \code{phyloseq} or \code{TreeSummarizedExperiment} object.
}
\details{
This function extracts the OTU table (or assay in \code{TSE}), computes per-ASV statistics,
and returns a tidy summary data frame.
}
\examples{
# Example with a phyloseq object
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_ITSOTU", package = "DspikeIn")
  summary_physeq <- summ_ASV_OTUID(physeq_ITSOTU)

  # Example with a TreeSummarizedExperiment object
  tse_ITSOTU <- convert_phyloseq_to_tse(physeq_ITSOTU)
  summary_tse <- summ_ASV_OTUID(tse_ITSOTU)
}

}
