% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_level_metrics.R
\name{node_level_metrics}
\alias{node_level_metrics}
\title{Compute and Visualize Node-Level Network Metrics}
\usage{
node_level_metrics(graph, save_path = NULL)
}
\arguments{
\item{graph}{An \code{igraph} object representing the network.}

\item{save_path}{Character. A file path (without extension) to save figures and table. Default is NULL (no saving).}
}
\value{
A list containing:
\itemize{
\item \code{metrics}: A data frame with node-level metrics.
\item \code{plot1}: First multi-panel plot (2x2 layout with 4 subplots)
\item \code{plot2}: Second multi-panel plot (2x2 layout with 4 subplots)
\item \code{facet_plot}: A faceted plot showing \strong{Z-score standardized} metrics across communities.
}
}
\description{
Computes various network metrics and generates:
\itemize{
\item Two \strong{multi-panel visualizations} (each with 4 subplots).
\item A \strong{faceted plot} of standardized (Z-score) metrics across communities.
\item A \strong{formatted flextable} summarizing node-level metrics.
}
}
\details{
The function computes the following node-level metrics:\tabular{ll}{
   \strong{Metric} \tab \strong{Description} \cr
   \code{Node} \tab Node name (character format) \cr
   \code{Degree} \tab Number of edges connected to the node \cr
   \code{Strength} \tab Sum of edge weights connected to the node \cr
   \code{Closeness} \tab Closeness centrality (normalized, based on shortest paths) \cr
   \code{Betweenness} \tab Betweenness centrality (normalized, measures control over network flow) \cr
   \code{EigenvectorCentrality} \tab Eigenvector centrality (importance based on connections to influential nodes) \cr
   \code{PageRank} \tab PageRank score (importance based on incoming links) \cr
   \code{Transitivity} \tab Local clustering coefficient (tendency of a node to form triangles) \cr
   \code{Coreness} \tab Node's coreness (from k-core decomposition) \cr
   \code{Constraint} \tab Burt's constraint (measures structural holes in a node's ego network) \cr
   \code{EffectiveSize} \tab Inverse of constraint (larger values = more non-redundant connections) \cr
   \code{Redundancy} \tab Sum of constraint values of a node's alters \cr
   \code{Community} \tab Community assignment from Louvain clustering \cr
   \code{Efficiency} \tab Global efficiency (average inverse shortest path length) \cr
   \code{Local_Efficiency} \tab Local efficiency (subgraph efficiency for a node's neighbors) \cr
   \code{Within_Module_Connectivity} \tab Proportion of neighbors in the same community \cr
   \code{Among_Module_Connectivity} \tab Proportion of neighbors in different communities \cr
}
}
\examples{
library(igraph)
set.seed(42)
# For external graphml please use full address
# Load internal graphml
Complete <- load_graphml("Complete.graphml")

# Compute node-level metrics
result <- node_level_metrics(Complete)

# View computed metrics
print(result$metrics)

# Show the first 4x4 plot
print(result$plots$plot1)

# Show the second 4x4 plot
print(result$plots$plot2)

# Show facet plot
print(result$facet_plot)

# Print metrics and flextable
print(result$metrics)
print(result$flextable)
}
